/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.DefaultConfigurableFileTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFileTree
extends AbstractFileTree {
    private final Map<RelativePath, Closure> elements = new LinkedHashMap<RelativePath, Closure>();
    private final File tmpDir;

    public MapFileTree(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Override
    public String getDisplayName() {
        return "file tree";
    }

    @Override
    protected Collection<DefaultConfigurableFileTree> getAsFileTrees() {
        this.visitAll();
        return Collections.singleton(new DefaultConfigurableFileTree(this.tmpDir, null, null));
    }

    @Override
    public FileTree visit(FileVisitor visitor) {
        AtomicBoolean stopFlag = new AtomicBoolean();
        Visit visit = new Visit(visitor, stopFlag);
        for (Map.Entry<RelativePath, Closure> entry : this.elements.entrySet()) {
            if (stopFlag.get()) break;
            RelativePath path = entry.getKey();
            Closure generator = entry.getValue();
            visit.visit(path, generator);
        }
        return this;
    }

    public void add(String path, Closure contentClosure) {
        this.elements.put(RelativePath.parse(true, path), contentClosure);
    }

    private class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final RelativePath path;
        private final Closure generator;
        private final long lastModified;
        private final AtomicBoolean stopFlag;
        private File file;

        public FileVisitDetailsImpl(RelativePath path, Closure generator, AtomicBoolean stopFlag) {
            this.path = path;
            this.generator = generator;
            this.stopFlag = stopFlag;
            this.lastModified = System.currentTimeMillis() / 1000L * 1000L;
        }

        public String getDisplayName() {
            return this.path.toString();
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = this.path.getFile(MapFileTree.this.tmpDir);
                this.copyTo(this.file);
            }
            return this.file;
        }

        public boolean isDirectory() {
            return !this.path.isFile();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getSize() {
            return this.getFile().length();
        }

        public void copyTo(OutputStream outstr) {
            this.generator.call((Object)outstr);
        }

        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativePath() {
            return this.path;
        }
    }

    private class Visit {
        private final Set<RelativePath> visitedDirs = new LinkedHashSet<RelativePath>();
        private final FileVisitor visitor;
        private final AtomicBoolean stopFlag;

        public Visit(FileVisitor visitor, AtomicBoolean stopFlag) {
            this.visitor = visitor;
            this.stopFlag = stopFlag;
        }

        private void visitDirs(RelativePath path, FileVisitor visitor) {
            if (path == null || path.getParent() == null || !this.visitedDirs.add(path)) {
                return;
            }
            this.visitDirs(path.getParent(), visitor);
            visitor.visitDir(new FileVisitDetailsImpl(path, null, this.stopFlag));
        }

        public void visit(RelativePath path, Closure generator) {
            this.visitDirs(path.getParent(), this.visitor);
            this.visitor.visitFile(new FileVisitDetailsImpl(path, generator, this.stopFlag));
        }
    }
}

