/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.DefaultDirectoryWalker;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileSetHelper;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.copy.FileCopyActionImpl;
import org.gradle.api.internal.file.copy.FileCopySpecVisitor;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurableFileTree
extends AbstractFileTree
implements ConfigurableFileTree {
    private PatternSet patternSet = new PatternSet();
    private Object dir;
    private final FileResolver resolver;
    private final DefaultTaskDependency buildDependency;
    private TaskResolver taskResolver;

    public DefaultConfigurableFileTree(Object dir, FileResolver resolver, TaskResolver taskResolver) {
        this(Collections.singletonMap("dir", dir), resolver, taskResolver);
    }

    public DefaultConfigurableFileTree(Map<String, ?> args, FileResolver resolver, TaskResolver taskResolver) {
        this.resolver = resolver != null ? resolver : new IdentityFileResolver();
        ConfigureUtil.configureByMap(args, this);
        this.buildDependency = new DefaultTaskDependency(taskResolver);
    }

    public PatternSet getPatternSet() {
        return this.patternSet;
    }

    public void setPatternSet(PatternSet patternSet) {
        this.patternSet = patternSet;
    }

    @Override
    public DefaultConfigurableFileTree setDir(Object dir) {
        this.from(dir);
        return this;
    }

    @Override
    public File getDir() {
        if (this.dir == null) {
            throw new InvalidUserDataException("A base directory must be specified in the task or via a method argument!");
        }
        return this.resolver.resolve(this.dir);
    }

    @Override
    public DefaultConfigurableFileTree from(Object dir) {
        this.dir = dir;
        return this;
    }

    @Override
    public String getDisplayName() {
        return String.format("file set '%s'", this.dir);
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        PatternSet patternSet = this.patternSet.intersect();
        patternSet.copyFrom(patterns);
        DefaultConfigurableFileTree filtered = new DefaultConfigurableFileTree(this.getDir(), this.resolver, this.taskResolver);
        filtered.setPatternSet(patternSet);
        return filtered;
    }

    @Override
    public DefaultConfigurableFileTree visit(FileVisitor visitor) {
        DefaultDirectoryWalker walker = new DefaultDirectoryWalker(visitor);
        walker.match(this.patternSet).start(this.getDir());
        return this;
    }

    public WorkResult copy(Closure closure) {
        FileCopyActionImpl action = new FileCopyActionImpl(this.resolver, new FileCopySpecVisitor());
        action.from(this);
        ConfigureUtil.configure(closure, action);
        action.execute();
        return action;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public DefaultConfigurableFileTree setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public DefaultConfigurableFileTree setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public DefaultConfigurableFileTree exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public boolean contains(File file) {
        String prefix = this.getDir().getAbsolutePath() + File.separator;
        if (!file.getAbsolutePath().startsWith(prefix)) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        RelativePath path = new RelativePath(true, file.getAbsolutePath().substring(prefix.length()).split(Pattern.quote(File.separator)));
        return this.patternSet.getAsSpec().isSatisfiedBy(new DefaultFileTreeElement(file, path));
    }

    @Override
    protected void addAsFileSet(Object builder, String nodeName) {
        File dir = this.getDir();
        if (!dir.exists()) {
            return;
        }
        this.doAddFileSet(builder, dir, nodeName);
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        this.addAsFileSet(builder, nodeName);
    }

    @Override
    protected Collection<DefaultConfigurableFileTree> getAsFileTrees() {
        return this.getDir().exists() ? Collections.singletonList(this) : Collections.emptyList();
    }

    protected Object doAddFileSet(Object builder, File dir, String nodeName) {
        new FileSetHelper().addToAntBuilder(builder, dir, this.patternSet, nodeName);
        return this;
    }

    @Override
    public ConfigurableFileTree builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getValues();
    }

    @Override
    public ConfigurableFileTree setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.buildDependency;
    }
}

