/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotter;
import org.gradle.api.internal.changedetection.Hasher;
import org.gradle.api.internal.changedetection.MapMergeChangeListener;
import org.gradle.api.internal.file.SimpleFileCollection;
import org.gradle.util.ChangeListener;
import org.gradle.util.NoOpChangeListener;

public class DefaultFileSnapshotter
implements FileSnapshotter {
    private final Hasher hasher;

    public DefaultFileSnapshotter(Hasher hasher) {
        this.hasher = hasher;
    }

    public FileCollectionSnapshot snapshot() {
        return new FileCollectionSnapshotImpl(new HashMap<String, FileSnapshot>());
    }

    public FileCollectionSnapshot snapshot(FileCollection sourceFiles) {
        HashMap<String, FileSnapshot> snapshots = new HashMap<String, FileSnapshot>();
        for (File file : sourceFiles.getAsFileTree()) {
            if (file.isFile()) {
                snapshots.put(file.getAbsolutePath(), new FileHashSnapshot(this.hasher.hash(file)));
                continue;
            }
            if (file.isDirectory()) {
                snapshots.put(file.getAbsolutePath(), new DirSnapshot());
                continue;
            }
            snapshots.put(file.getAbsolutePath(), new MissingFileSnapshot());
        }
        return new FileCollectionSnapshotImpl(snapshots);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCollectionSnapshotImpl
    implements FileCollectionSnapshot {
        private final Map<String, FileSnapshot> snapshots;

        public FileCollectionSnapshotImpl(Map<String, FileSnapshot> snapshots) {
            this.snapshots = snapshots;
        }

        @Override
        public FileCollection getFiles() {
            ArrayList<File> files = new ArrayList<File>();
            for (Map.Entry<String, FileSnapshot> entry : this.snapshots.entrySet()) {
                if (!(entry.getValue() instanceof FileHashSnapshot)) continue;
                files.add(new File(entry.getKey()));
            }
            return new SimpleFileCollection(files);
        }

        @Override
        public void changesSince(FileCollectionSnapshot oldSnapshot, final ChangeListener<File> listener) {
            FileCollectionSnapshotImpl other = (FileCollectionSnapshotImpl)oldSnapshot;
            this.diff(this.snapshots, other.snapshots, new ChangeListener<Map.Entry<String, FileSnapshot>>(){

                @Override
                public void added(Map.Entry<String, FileSnapshot> element) {
                    listener.added(new File(element.getKey()));
                }

                @Override
                public void removed(Map.Entry<String, FileSnapshot> element) {
                    listener.removed(new File(element.getKey()));
                }

                @Override
                public void changed(Map.Entry<String, FileSnapshot> element) {
                    listener.changed(new File(element.getKey()));
                }
            });
        }

        private void diff(Map<String, FileSnapshot> snapshots, Map<String, FileSnapshot> oldSnapshots, ChangeListener<Map.Entry<String, FileSnapshot>> listener) {
            HashMap<String, FileSnapshot> otherSnapshots = new HashMap<String, FileSnapshot>(oldSnapshots);
            for (Map.Entry<String, FileSnapshot> entry : snapshots.entrySet()) {
                FileSnapshot otherFile = (FileSnapshot)otherSnapshots.remove(entry.getKey());
                if (otherFile == null) {
                    listener.added(entry);
                    continue;
                }
                if (entry.getValue().isUpToDate(otherFile)) continue;
                listener.changed(entry);
            }
            for (Map.Entry<String, FileSnapshot> entry : otherSnapshots.entrySet()) {
                listener.removed(entry);
            }
        }

        @Override
        public FileCollectionSnapshot.Diff changesSince(FileCollectionSnapshot oldSnapshot) {
            final FileCollectionSnapshotImpl other = (FileCollectionSnapshotImpl)oldSnapshot;
            return new FileCollectionSnapshot.Diff(){

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot) {
                    return this.applyTo(snapshot, new NoOpChangeListener<FileCollectionSnapshot.Merge>());
                }

                @Override
                public FileCollectionSnapshot applyTo(FileCollectionSnapshot snapshot, ChangeListener<FileCollectionSnapshot.Merge> listener) {
                    FileCollectionSnapshotImpl target = (FileCollectionSnapshotImpl)snapshot;
                    HashMap<String, FileSnapshot> newSnapshots = new HashMap<String, FileSnapshot>(target.snapshots);
                    FileCollectionSnapshotImpl.this.diff(FileCollectionSnapshotImpl.this.snapshots, other.snapshots, new MapMergeChangeListener(listener, newSnapshots));
                    return new FileCollectionSnapshotImpl(newSnapshots);
                }
            };
        }
    }

    private static class MissingFileSnapshot
    implements FileSnapshot {
        private MissingFileSnapshot() {
        }

        public boolean isUpToDate(FileSnapshot snapshot) {
            return snapshot instanceof MissingFileSnapshot;
        }
    }

    private static class DirSnapshot
    implements FileSnapshot {
        private DirSnapshot() {
        }

        public boolean isUpToDate(FileSnapshot snapshot) {
            return snapshot instanceof DirSnapshot;
        }
    }

    private static class FileHashSnapshot
    implements FileSnapshot {
        private final byte[] hash;

        public FileHashSnapshot(byte[] hash) {
            this.hash = hash;
        }

        public boolean isUpToDate(FileSnapshot snapshot) {
            if (!(snapshot instanceof FileHashSnapshot)) {
                return false;
            }
            FileHashSnapshot other = (FileHashSnapshot)snapshot;
            return Arrays.equals(this.hash, other.hash);
        }

        public String toString() {
            return new BigInteger(1, this.hash).toString(16);
        }
    }

    private static interface FileSnapshot
    extends Serializable {
        public boolean isUpToDate(FileSnapshot var1);
    }
}

