/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish.maven.deploy;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.settings.Settings;
import org.apache.tools.ant.Project;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.artifacts.maven.PublishFilter;
import org.gradle.api.internal.artifacts.publish.maven.deploy.ArtifactPomContainer;
import org.gradle.api.internal.artifacts.publish.maven.deploy.CustomInstallDeployTaskSupport;
import org.gradle.api.internal.artifacts.publish.maven.deploy.DefaultMavenDeployment;
import org.gradle.api.internal.artifacts.publish.maven.deploy.PomFilter;
import org.gradle.api.logging.LogLevel;
import org.gradle.listener.ActionBroadcast;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.util.AntUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenResolver
implements MavenResolver {
    protected static final String SETTINGS_XML = "<settings/>";
    private String name;
    private ArtifactPomContainer artifactPomContainer;
    private PomFilterContainer pomFilterContainer;
    private Settings settings;
    private LoggingManagerInternal loggingManager;
    private final ActionBroadcast<MavenDeployment> beforeDeploymentActions = new ActionBroadcast();

    public AbstractMavenResolver(String name, PomFilterContainer pomFilterContainer, ArtifactPomContainer artifactPomContainer, LoggingManagerInternal loggingManager) {
        this.name = name;
        this.pomFilterContainer = pomFilterContainer;
        this.artifactPomContainer = artifactPomContainer;
        this.loggingManager = loggingManager;
    }

    protected abstract InstallDeployTaskSupport createPreConfiguredTask(Project var1);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public ArtifactDownloadReport download(ArtifactOrigin artifact, DownloadOptions options) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public boolean exists(Artifact artifact) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public ArtifactOrigin locate(Artifact artifact) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public void reportFailure() {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public void reportFailure(Artifact art) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public Map[] listTokenValues(String[] tokens, Map criteria) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public OrganisationEntry[] listOrganisations() {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public RevisionEntry[] listRevisions(ModuleEntry module) {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public Namespace getNamespace() {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public void dumpSettings() {
        throw new UnsupportedOperationException("A MavenPublishOnlyResolver can only publish artifacts.");
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        if (this.isIgnorable(artifact)) {
            return;
        }
        this.getArtifactPomContainer().addArtifact(artifact, src);
    }

    private boolean isIgnorable(Artifact artifact) {
        return artifact.getType().equals("ivy");
    }

    public void beginPublishTransaction(ModuleRevisionId module, boolean overwrite) throws IOException {
    }

    public void abortPublishTransaction() throws IOException {
    }

    public void commitPublishTransaction() throws IOException {
        InstallDeployTaskSupport installDeployTaskSupport = this.createPreConfiguredTask(AntUtil.createProject());
        Set<DefaultMavenDeployment> defaultMavenDeployments = this.getArtifactPomContainer().createDeployableFilesInfos();
        File emptySettingsXml = this.createEmptyMavenSettingsXml();
        installDeployTaskSupport.setSettingsFile(emptySettingsXml);
        for (DefaultMavenDeployment defaultMavenDeployment : defaultMavenDeployments) {
            this.beforeDeploymentActions.execute(defaultMavenDeployment);
            this.addPomAndArtifact(installDeployTaskSupport, defaultMavenDeployment);
            this.execute(installDeployTaskSupport);
        }
        emptySettingsXml.delete();
        this.settings = ((CustomInstallDeployTaskSupport)installDeployTaskSupport).getSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(InstallDeployTaskSupport deployTask) {
        this.loggingManager.captureStandardOutput(LogLevel.INFO).start();
        try {
            deployTask.execute();
        }
        finally {
            this.loggingManager.stop();
        }
    }

    private void addPomAndArtifact(InstallDeployTaskSupport installOrDeployTask, DefaultMavenDeployment defaultMavenDeployment) {
        Pom pom = new Pom();
        pom.setProject(installOrDeployTask.getProject());
        pom.setFile(defaultMavenDeployment.getPomArtifact().getFile());
        installOrDeployTask.addPom(pom);
        if (defaultMavenDeployment.getMainArtifact() != null) {
            installOrDeployTask.setFile(defaultMavenDeployment.getMainArtifact().getFile());
        }
        for (PublishArtifact classifierArtifact : defaultMavenDeployment.getAttachedArtifacts()) {
            AttachedArtifact attachedArtifact = installOrDeployTask.createAttach();
            attachedArtifact.setClassifier(classifierArtifact.getClassifier());
            attachedArtifact.setFile(classifierArtifact.getFile());
            attachedArtifact.setType(classifierArtifact.getType());
        }
    }

    private File createEmptyMavenSettingsXml() {
        try {
            File settingsXml = File.createTempFile("gradle_empty_settings", ".xml");
            FileUtils.writeStringToFile((File)settingsXml, (String)SETTINGS_XML);
            return settingsXml;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setSettings(ResolverSettings settings) {
    }

    public RepositoryCacheManager getRepositoryCacheManager() {
        return new DefaultRepositoryCacheManager();
    }

    public ArtifactPomContainer getArtifactPomContainer() {
        return this.artifactPomContainer;
    }

    public void setArtifactPomContainer(ArtifactPomContainer artifactPomContainer) {
        this.artifactPomContainer = artifactPomContainer;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public PublishFilter getFilter() {
        return this.pomFilterContainer.getFilter();
    }

    @Override
    public void setFilter(PublishFilter defaultFilter) {
        this.pomFilterContainer.setFilter(defaultFilter);
    }

    @Override
    public MavenPom getPom() {
        return this.pomFilterContainer.getPom();
    }

    @Override
    public void setPom(MavenPom defaultPom) {
        this.pomFilterContainer.setPom(defaultPom);
    }

    @Override
    public MavenPom addFilter(String name, PublishFilter publishFilter) {
        return this.pomFilterContainer.addFilter(name, publishFilter);
    }

    @Override
    public MavenPom addFilter(String name, Closure filter) {
        return this.pomFilterContainer.addFilter(name, filter);
    }

    @Override
    public void filter(Closure filter) {
        this.pomFilterContainer.filter(filter);
    }

    @Override
    public PublishFilter filter(String name) {
        return this.pomFilterContainer.filter(name);
    }

    @Override
    public MavenPom pom(String name) {
        return this.pomFilterContainer.pom(name);
    }

    @Override
    public MavenPom pom(Closure configureClosure) {
        return this.pomFilterContainer.pom(configureClosure);
    }

    @Override
    public MavenPom pom(String name, Closure configureClosure) {
        return this.pomFilterContainer.pom(name, configureClosure);
    }

    @Override
    public Iterable<PomFilter> getActivePomFilters() {
        return this.pomFilterContainer.getActivePomFilters();
    }

    public PomFilterContainer getPomFilterContainer() {
        return this.pomFilterContainer;
    }

    public void setPomFilterContainer(PomFilterContainer pomFilterContainer) {
        this.pomFilterContainer = pomFilterContainer;
    }

    @Override
    public void beforeDeployment(Action<? super MavenDeployment> action) {
        this.beforeDeploymentActions.add(action);
    }

    @Override
    public void beforeDeployment(Closure action) {
        this.beforeDeploymentActions.add(action);
    }
}

