/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish.maven.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.maven.Conf2ScopeMapping;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConf2ScopeMappingContainer
implements Conf2ScopeMappingContainer {
    private Map<Configuration, Conf2ScopeMapping> mappings = new HashMap<Configuration, Conf2ScopeMapping>();
    private boolean skipUnmappedConfs = true;

    public DefaultConf2ScopeMappingContainer() {
    }

    public DefaultConf2ScopeMappingContainer(Map<Configuration, Conf2ScopeMapping> mappings) {
        this.mappings.putAll(mappings);
    }

    @Override
    public Conf2ScopeMapping getMapping(Collection<Configuration> configurations) {
        Set<Conf2ScopeMapping> result = this.getMappingsWithHighestPriority(configurations);
        if (result.size() > 1) {
            throw new InvalidUserDataException("The configuration to scope mapping is not unique. The following configurations have the same priority: " + result);
        }
        return result.size() == 0 ? null : result.iterator().next();
    }

    private Set<Conf2ScopeMapping> getMappingsWithHighestPriority(Collection<Configuration> configurations) {
        Integer lastPriority = null;
        Set<Conf2ScopeMapping> result = new HashSet<Conf2ScopeMapping>();
        for (Conf2ScopeMapping conf2ScopeMapping : this.getMappingsForConfigurations(configurations)) {
            Integer thisPriority = conf2ScopeMapping.getPriority();
            if (lastPriority != null && lastPriority.equals(thisPriority)) {
                result.add(conf2ScopeMapping);
                continue;
            }
            if (lastPriority != null && (thisPriority == null || lastPriority >= thisPriority)) continue;
            lastPriority = thisPriority;
            result = WrapUtil.toSet(conf2ScopeMapping);
        }
        return result;
    }

    private List<Conf2ScopeMapping> getMappingsForConfigurations(Collection<Configuration> configurations) {
        ArrayList<Conf2ScopeMapping> existingMappings = new ArrayList<Conf2ScopeMapping>();
        for (Configuration configuration : configurations) {
            if (this.mappings.get(configuration) != null) {
                existingMappings.add(this.mappings.get(configuration));
                continue;
            }
            existingMappings.add(new Conf2ScopeMapping(null, configuration, null));
        }
        return existingMappings;
    }

    @Override
    public Conf2ScopeMappingContainer addMapping(int priority, Configuration configuration, String scope) {
        this.mappings.put(configuration, new Conf2ScopeMapping(priority, configuration, scope));
        return this;
    }

    @Override
    public Map<Configuration, Conf2ScopeMapping> getMappings() {
        return this.mappings;
    }

    @Override
    public boolean isSkipUnmappedConfs() {
        return this.skipUnmappedConfs;
    }

    @Override
    public void setSkipUnmappedConfs(boolean skipUnmappedConfs) {
        this.skipUnmappedConfs = skipUnmappedConfs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConf2ScopeMappingContainer that = (DefaultConf2ScopeMappingContainer)o;
        return ((Object)this.mappings).equals(that.mappings);
    }

    public int hashCode() {
        return ((Object)this.mappings).hashCode();
    }
}

