/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.AbstractDependencyDescriptorFactoryInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ProjectDependencyDescriptorStrategy;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.WrapUtil;

public class ProjectDependencyDescriptorFactory
extends AbstractDependencyDescriptorFactoryInternal {
    public static final ProjectDependencyDescriptorStrategy IVY_FILE_DESCRIPTOR_STRATEGY = new ProjectDependencyDescriptorStrategy(){

        public ModuleRevisionId createModuleRevisionId(ProjectDependency dependency) {
            Module module = ((ProjectInternal)dependency.getDependencyProject()).getModule();
            return IvyUtil.createModuleRevisionId(module);
        }

        public boolean isChanging() {
            return false;
        }
    };
    public static final ProjectDependencyDescriptorStrategy RESOLVE_DESCRIPTOR_STRATEGY = new ProjectDependencyDescriptorStrategy(){

        public ModuleRevisionId createModuleRevisionId(ProjectDependency dependency) {
            Module module = ((ProjectInternal)dependency.getDependencyProject()).getModule();
            return IvyUtil.createModuleRevisionId(module, WrapUtil.toMap("org.gradle.projectPath", dependency.getDependencyProject().getPath()));
        }

        public boolean isChanging() {
            return true;
        }
    };
    private ProjectDependencyDescriptorStrategy projectDependencyDescriptorStrategy;

    public ProjectDependencyDescriptorFactory(ExcludeRuleConverter excludeRuleConverter, ProjectDependencyDescriptorStrategy projectDependencyDescriptorStrategy) {
        super(excludeRuleConverter);
        this.projectDependencyDescriptorStrategy = projectDependencyDescriptorStrategy;
    }

    public DependencyDescriptor createDependencyDescriptor(ModuleDependency dependency, String configuration, ModuleDescriptor parent, ModuleRevisionId moduleRevisionId) {
        DefaultDependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor(parent, moduleRevisionId, false, this.projectDependencyDescriptorStrategy.isChanging(), dependency.isTransitive());
        this.addExcludesArtifactsAndDependencies(configuration, dependency, dependencyDescriptor);
        return dependencyDescriptor;
    }

    public boolean canConvert(ModuleDependency dependency) {
        return dependency instanceof ProjectDependency;
    }

    public ModuleRevisionId createModuleRevisionId(ModuleDependency dependency) {
        return this.projectDependencyDescriptorStrategy.createModuleRevisionId((ProjectDependency)dependency);
    }
}

