/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.settings.IvySettings;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Module;
import org.gradle.api.internal.artifacts.ivyservice.ModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ArtifactsToModuleDescriptorConverter;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishModuleDescriptorConverter
implements ModuleDescriptorConverter {
    static final String IVY_MAVEN_NAMESPACE = "http://ant.apache.org/ivy/maven";
    static final String IVY_MAVEN_NAMESPACE_PREFIX = "m";
    private static Logger logger = LoggerFactory.getLogger(PublishModuleDescriptorConverter.class);
    private ModuleDescriptorConverter resolveModuleDescriptorConverter;
    private ArtifactsToModuleDescriptorConverter artifactsToModuleDescriptorConverter;

    public PublishModuleDescriptorConverter(ModuleDescriptorConverter resolveModuleDescriptorConverter, ArtifactsToModuleDescriptorConverter artifactsToModuleDescriptorConverter) {
        this.resolveModuleDescriptorConverter = resolveModuleDescriptorConverter;
        this.artifactsToModuleDescriptorConverter = artifactsToModuleDescriptorConverter;
    }

    @Override
    public ModuleDescriptor convert(Set<Configuration> configurations, Module module, IvySettings settings) {
        Clock clock = new Clock();
        DefaultModuleDescriptor moduleDescriptor = (DefaultModuleDescriptor)this.resolveModuleDescriptorConverter.convert(configurations, module, settings);
        moduleDescriptor.addExtraAttributeNamespace(IVY_MAVEN_NAMESPACE_PREFIX, IVY_MAVEN_NAMESPACE);
        this.artifactsToModuleDescriptorConverter.addArtifacts(moduleDescriptor, configurations);
        logger.debug("Timing: Ivy convert for publish took {}", (Object)clock.getTime());
        return moduleDescriptor;
    }

    public ArtifactsToModuleDescriptorConverter getArtifactsToModuleDescriptorConverter() {
        return this.artifactsToModuleDescriptorConverter;
    }

    public void setArtifactsToModuleDescriptorConverter(ArtifactsToModuleDescriptorConverter artifactsToModuleDescriptorConverter) {
        this.artifactsToModuleDescriptorConverter = artifactsToModuleDescriptorConverter;
    }
}

