/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.lang.reflect.Field;
import org.apache.maven.settings.DefaultMavenSettingsBuilder;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.gradle.api.internal.artifacts.publish.maven.pombuilder.PlexusLoggerAdapter;
import org.gradle.util.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMavenCacheLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalMavenCacheLocator.class);
    private static final String USER_HOME_MARKER = "${user.home}/";

    public File getLocalMavenCache() {
        File overriddenMavenLocal;
        File userHome = new File(System.getProperty("user.home"));
        File m2Dir = new File(userHome, ".m2");
        File userSettings = new File(m2Dir, "settings.xml");
        if (userSettings.exists() && (overriddenMavenLocal = this.extractMavenLocal(userSettings, userHome)) != null) {
            return overriddenMavenLocal;
        }
        return new File(m2Dir, "repository");
    }

    private File extractMavenLocal(File userSettings, File userHome) {
        Settings settings = this.extractSettings(userSettings);
        String override = settings.getLocalRepository();
        if (override != null && (override = override.trim()).length() > 0) {
            if (override.startsWith(USER_HOME_MARKER)) {
                override = userHome.getAbsolutePath() + '/' + override.substring(USER_HOME_MARKER.length());
            }
            return new File(override);
        }
        return null;
    }

    private Settings extractSettings(File userSettings) {
        try {
            MavenSettingsBuilder builder = this.buildSettingsBuilder(userSettings);
            return builder.buildSettings();
        }
        catch (Exception e) {
            throw UncheckedException.asUncheckedException(e);
        }
    }

    private MavenSettingsBuilder buildSettingsBuilder(File userSettings) throws Exception {
        String userSettingsPath = userSettings.getAbsolutePath();
        DefaultMavenSettingsBuilder builder = new DefaultMavenSettingsBuilder();
        builder.enableLogging((org.codehaus.plexus.logging.Logger)new PlexusLoggerAdapter(LOGGER));
        Field userSettingsPathField = DefaultMavenSettingsBuilder.class.getDeclaredField("userSettingsPath");
        userSettingsPathField.setAccessible(true);
        userSettingsPathField.set(builder, userSettingsPath);
        Field globalSettingsPathField = DefaultMavenSettingsBuilder.class.getDeclaredField("globalSettingsPath");
        globalSettingsPathField.setAccessible(true);
        globalSettingsPathField.set(builder, userSettingsPath);
        builder.initialize();
        return builder;
    }
}

