/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.DualResolver;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.maven.GroovyMavenDeployer;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.artifacts.ivyservice.GradleIBiblioResolver;
import org.gradle.api.internal.artifacts.ivyservice.LocalMavenCacheLocator;
import org.gradle.api.internal.artifacts.ivyservice.ResolverFactory;
import org.gradle.api.internal.artifacts.publish.maven.DefaultArtifactPomFactory;
import org.gradle.api.internal.artifacts.publish.maven.DefaultMavenPomFactory;
import org.gradle.api.internal.artifacts.publish.maven.MavenPomMetaInfoProvider;
import org.gradle.api.internal.artifacts.publish.maven.dependencies.DefaultExcludeRuleConverter;
import org.gradle.api.internal.artifacts.publish.maven.dependencies.DefaultPomDependenciesConverter;
import org.gradle.api.internal.artifacts.publish.maven.deploy.BaseMavenInstaller;
import org.gradle.api.internal.artifacts.publish.maven.deploy.BasePomFilterContainer;
import org.gradle.api.internal.artifacts.publish.maven.deploy.DefaultArtifactPomContainer;
import org.gradle.api.internal.artifacts.publish.maven.deploy.groovy.DefaultGroovyMavenDeployer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.util.DeleteOnExit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolverFactory
implements ResolverFactory {
    private final Factory<? extends LoggingManagerInternal> loggingManagerFactory;
    private final LocalMavenCacheLocator localMavenCacheLocator;

    public DefaultResolverFactory(Factory<? extends LoggingManagerInternal> loggingManagerFactory) {
        this(loggingManagerFactory, new LocalMavenCacheLocator());
    }

    DefaultResolverFactory(Factory<? extends LoggingManagerInternal> loggingManagerFactory, LocalMavenCacheLocator localMavenCacheLocator) {
        this.loggingManagerFactory = loggingManagerFactory;
        this.localMavenCacheLocator = localMavenCacheLocator;
    }

    @Override
    public DependencyResolver createResolver(Object userDescription) {
        AbstractResolver result;
        if (userDescription instanceof String) {
            result = this.createMavenRepoResolver((String)userDescription, (String)userDescription, new String[0]);
        } else if (userDescription instanceof Map) {
            Map userDescriptionMap = (Map)userDescription;
            result = this.createMavenRepoResolver((String)userDescriptionMap.get("name"), (String)userDescriptionMap.get("url"), new String[0]);
        } else if (userDescription instanceof DependencyResolver) {
            result = (DependencyResolver)userDescription;
        } else {
            throw new InvalidUserDataException("Illegal Resolver type");
        }
        return result;
    }

    @Override
    public FileSystemResolver createFlatDirResolver(String name, File ... roots) {
        FileSystemResolver resolver = new FileSystemResolver();
        resolver.setName(name);
        for (File root : roots) {
            String pattern = root.getAbsolutePath() + "/" + "[artifact](-[revision])(-[classifier]).[ext]";
            resolver.addArtifactPattern(pattern);
        }
        resolver.setValidate(false);
        resolver.setRepositoryCacheManager(this.createUseOriginCacheManager(name));
        return resolver;
    }

    private RepositoryCacheManager createUseOriginCacheManager(String name) {
        File tmpIvyCache = this.createTmpDir();
        DefaultRepositoryCacheManager cacheManager = new DefaultRepositoryCacheManager();
        cacheManager.setBasedir(tmpIvyCache);
        cacheManager.setName(name);
        cacheManager.setUseOrigin(true);
        cacheManager.setLockStrategy((LockStrategy)new NoLockStrategy());
        cacheManager.setIvyPattern("[organisation]/[module](/[branch])/ivy-[revision].xml");
        cacheManager.setArtifactPattern("[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])");
        return cacheManager;
    }

    private File createTmpDir() {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("gradle_ivy_cache", "");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        tmpFile.delete();
        tmpFile.mkdir();
        DeleteOnExit.addFile(tmpFile);
        return tmpFile;
    }

    @Override
    public AbstractResolver createMavenLocalResolver(String name) {
        String cacheDir = this.localMavenCacheLocator.getLocalMavenCache().toURI().toString();
        return this.createMavenRepoResolver(name, cacheDir, new String[0]);
    }

    @Override
    public AbstractResolver createMavenRepoResolver(String name, String root, String ... jarRepoUrls) {
        GradleIBiblioResolver iBiblioResolver = this.createIBiblioResolver(name, root);
        if (jarRepoUrls.length == 0) {
            iBiblioResolver.setDescriptor("optional");
            return iBiblioResolver;
        }
        iBiblioResolver.setName(iBiblioResolver.getName() + "_poms");
        URLResolver urlResolver = this.createUrlResolver(name, root, jarRepoUrls);
        return this.createDualResolver(name, iBiblioResolver, urlResolver);
    }

    private GradleIBiblioResolver createIBiblioResolver(String name, String root) {
        GradleIBiblioResolver iBiblioResolver = new GradleIBiblioResolver();
        iBiblioResolver.setUsepoms(true);
        iBiblioResolver.setName(name);
        iBiblioResolver.setRoot(root);
        iBiblioResolver.setPattern("[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]");
        iBiblioResolver.setM2compatible(true);
        iBiblioResolver.setUseMavenMetadata(true);
        return iBiblioResolver;
    }

    private URLResolver createUrlResolver(String name, String root, String ... jarRepoUrls) {
        URLResolver urlResolver = new URLResolver();
        urlResolver.setName(name + "_jars");
        urlResolver.setM2compatible(true);
        urlResolver.addArtifactPattern(root + '/' + "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]");
        for (String jarRepoUrl : jarRepoUrls) {
            urlResolver.addArtifactPattern(jarRepoUrl + '/' + "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]");
        }
        return urlResolver;
    }

    private DualResolver createDualResolver(String name, GradleIBiblioResolver iBiblioResolver, URLResolver urlResolver) {
        DualResolver dualResolver = new DualResolver();
        dualResolver.setName(name);
        dualResolver.setIvyResolver((DependencyResolver)iBiblioResolver);
        dualResolver.setArtifactResolver((DependencyResolver)urlResolver);
        dualResolver.setDescriptor("optional");
        return dualResolver;
    }

    @Override
    public GroovyMavenDeployer createMavenDeployer(String name, MavenPomMetaInfoProvider pomMetaInfoProvider, ConfigurationContainer configurationContainer, Conf2ScopeMappingContainer scopeMapping, FileResolver fileResolver) {
        BasePomFilterContainer pomFilterContainer = new BasePomFilterContainer(new DefaultMavenPomFactory(configurationContainer, scopeMapping, new DefaultPomDependenciesConverter(new DefaultExcludeRuleConverter()), fileResolver));
        return new DefaultGroovyMavenDeployer(name, pomFilterContainer, new DefaultArtifactPomContainer(pomMetaInfoProvider, pomFilterContainer, new DefaultArtifactPomFactory()), this.loggingManagerFactory.create());
    }

    @Override
    public MavenResolver createMavenInstaller(String name, MavenPomMetaInfoProvider pomMetaInfoProvider, ConfigurationContainer configurationContainer, Conf2ScopeMappingContainer scopeMapping, FileResolver fileResolver) {
        BasePomFilterContainer pomFilterContainer = new BasePomFilterContainer(new DefaultMavenPomFactory(configurationContainer, scopeMapping, new DefaultPomDependenciesConverter(new DefaultExcludeRuleConverter()), fileResolver));
        return new BaseMavenInstaller(name, pomFilterContainer, new DefaultArtifactPomContainer(pomMetaInfoProvider, pomFilterContainer, new DefaultArtifactPomFactory()), this.loggingManagerFactory.create());
    }
}

