/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.internal.artifacts.IvyService;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.ResolverProvider;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.IvyFactory;
import org.gradle.api.internal.artifacts.ivyservice.ModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.SettingsConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyService
implements IvyService {
    private SettingsConverter settingsConverter;
    private ModuleDescriptorConverter resolveModuleDescriptorConverter;
    private ModuleDescriptorConverter publishModuleDescriptorConverter;
    private ModuleDescriptorConverter fileModuleDescriptorConverter;
    private IvyFactory ivyFactory;
    private IvyDependencyResolver dependencyResolver;
    private IvyDependencyPublisher dependencyPublisher;
    private final DependencyMetaDataProvider metaDataProvider;
    private final ResolverProvider resolverProvider;
    private Map clientModuleRegistry;

    public DefaultIvyService(DependencyMetaDataProvider metaDataProvider, ResolverProvider resolverProvider, SettingsConverter settingsConverter, ModuleDescriptorConverter resolveModuleDescriptorConverter, ModuleDescriptorConverter publishModuleDescriptorConverter, ModuleDescriptorConverter fileModuleDescriptorConverter, IvyFactory ivyFactory, IvyDependencyResolver dependencyResolver, IvyDependencyPublisher dependencyPublisher, Map clientModuleRegistry) {
        this.metaDataProvider = metaDataProvider;
        this.resolverProvider = resolverProvider;
        this.settingsConverter = settingsConverter;
        this.resolveModuleDescriptorConverter = resolveModuleDescriptorConverter;
        this.publishModuleDescriptorConverter = publishModuleDescriptorConverter;
        this.fileModuleDescriptorConverter = fileModuleDescriptorConverter;
        this.ivyFactory = ivyFactory;
        this.dependencyResolver = dependencyResolver;
        this.dependencyPublisher = dependencyPublisher;
        this.clientModuleRegistry = clientModuleRegistry;
    }

    private Ivy ivyForResolve(List<DependencyResolver> dependencyResolvers, File cacheParentDir, Map<String, ModuleDescriptor> clientModuleRegistry) {
        return this.ivyFactory.createIvy(this.settingsConverter.convertForResolve(dependencyResolvers, cacheParentDir, this.metaDataProvider.getInternalRepository(), clientModuleRegistry));
    }

    private Ivy ivyForPublish(List<DependencyResolver> publishResolvers, File cacheParentDir) {
        return this.ivyFactory.createIvy(this.settingsConverter.convertForPublish(publishResolvers, cacheParentDir, this.metaDataProvider.getInternalRepository()));
    }

    public SettingsConverter getSettingsConverter() {
        return this.settingsConverter;
    }

    public ModuleDescriptorConverter getResolveModuleDescriptorConverter() {
        return this.resolveModuleDescriptorConverter;
    }

    public ModuleDescriptorConverter getPublishModuleDescriptorConverter() {
        return this.publishModuleDescriptorConverter;
    }

    public ModuleDescriptorConverter getFileModuleDescriptorConverter() {
        return this.fileModuleDescriptorConverter;
    }

    public IvyFactory getIvyFactory() {
        return this.ivyFactory;
    }

    public DependencyMetaDataProvider getMetaDataProvider() {
        return this.metaDataProvider;
    }

    public ResolverProvider getResolverProvider() {
        return this.resolverProvider;
    }

    public IvyDependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public IvyDependencyPublisher getDependencyPublisher() {
        return this.dependencyPublisher;
    }

    @Override
    public ResolvedConfiguration resolve(Configuration configuration) {
        Ivy ivy = this.ivyForResolve(this.resolverProvider.getResolvers(), this.metaDataProvider.getGradleUserHomeDir(), this.clientModuleRegistry);
        ModuleDescriptor moduleDescriptor = this.resolveModuleDescriptorConverter.convert(configuration.getAll(), this.metaDataProvider.getModule(), ivy.getSettings());
        return this.dependencyResolver.resolve(configuration, ivy, moduleDescriptor);
    }

    @Override
    public void publish(Set<Configuration> configurationsToPublish, File descriptorDestination, List<DependencyResolver> publishResolvers) {
        Ivy ivy = this.ivyForPublish(publishResolvers, this.metaDataProvider.getGradleUserHomeDir());
        Set<String> confs = Configurations.getNames(configurationsToPublish, false);
        this.writeDescriptorFile(descriptorDestination, configurationsToPublish, ivy.getSettings());
        this.dependencyPublisher.publish(confs, publishResolvers, this.publishModuleDescriptorConverter.convert(configurationsToPublish, this.metaDataProvider.getModule(), ivy.getSettings()), descriptorDestination, ivy.getPublishEngine());
    }

    private void writeDescriptorFile(File descriptorDestination, Set<Configuration> configurationsToPublish, IvySettings ivySettings) {
        if (descriptorDestination == null) {
            return;
        }
        assert (configurationsToPublish.size() > 0);
        Set<Configuration> allConfigurations = configurationsToPublish.iterator().next().getAll();
        ModuleDescriptor moduleDescriptor = this.fileModuleDescriptorConverter.convert(allConfigurations, this.metaDataProvider.getModule(), ivySettings);
        try {
            moduleDescriptor.toIvyFile(descriptorDestination);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setSettingsConverter(SettingsConverter settingsConverter) {
        this.settingsConverter = settingsConverter;
    }

    public void setIvyFactory(IvyFactory ivyFactory) {
        this.ivyFactory = ivyFactory;
    }

    public void setDependencyResolver(IvyDependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    public void setDependencyPublisher(IvyDependencyPublisher dependencyPublisher) {
        this.dependencyPublisher = dependencyPublisher;
    }

    public Map getClientModuleRegistry() {
        return this.clientModuleRegistry;
    }

    public void setClientModuleRegistry(Map clientModuleRegistry) {
        this.clientModuleRegistry = clientModuleRegistry;
    }
}

