/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.DefaultResolvedDependency;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyConversionResult;
import org.gradle.api.internal.artifacts.ivyservice.IvyConversionResult;
import org.gradle.api.internal.artifacts.ivyservice.IvyReportConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.util.Clock;
import org.gradle.util.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyReportConverter
implements IvyReportConverter {
    private static Logger logger = LoggerFactory.getLogger(DefaultIvyReportConverter.class);
    private DependencyDescriptorFactory dependencyDescriptorFactory;

    public DefaultIvyReportConverter(DependencyDescriptorFactory dependencyDescriptorFactory) {
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
    }

    @Override
    public IvyConversionResult convertReport(ResolveReport resolveReport, org.gradle.api.artifacts.Configuration configuration) {
        Clock clock = new Clock();
        ReportConversionContext context = new ReportConversionContext(resolveReport, configuration);
        List<IvyNode> resolvedNodes = this.findResolvedNodes(resolveReport, context);
        for (IvyNode node : resolvedNodes) {
            this.constructConfigurationsForNode(node, context);
        }
        for (IvyNode node : resolvedNodes) {
            this.attachToParents(node, context);
        }
        if (context.root == null) {
            context.root = new DefaultResolvedDependency(resolveReport.getModuleDescriptor().getModuleRevisionId().getOrganisation(), resolveReport.getModuleDescriptor().getModuleRevisionId().getName(), resolveReport.getModuleDescriptor().getModuleRevisionId().getRevision(), configuration.getName(), Collections.EMPTY_SET);
        }
        logger.debug("Timing: Translating report for configuration {} took {}", (Object)configuration, (Object)clock.getTime());
        return new DefaultIvyConversionResult(context.root, context.firstLevelResolvedDependencies, context.resolvedArtifacts);
    }

    private List<IvyNode> findResolvedNodes(ResolveReport resolveReport, ReportConversionContext context) {
        List nodes = resolveReport.getDependencies();
        ArrayList<IvyNode> resolvedNodes = new ArrayList<IvyNode>();
        for (IvyNode node : nodes) {
            if (!this.isResolvedNode(node, context.conf)) continue;
            resolvedNodes.add(node);
        }
        if (!resolvedNodes.isEmpty()) {
            resolvedNodes.add(((IvyNode)resolvedNodes.get(0)).getRoot());
        }
        return resolvedNodes;
    }

    private boolean isResolvedNode(IvyNode node, String configuration) {
        return node.isLoaded() && !node.isEvicted(configuration);
    }

    private void attachToParents(IvyNode ivyNode, ReportConversionContext context) {
        Map<String, ConfigurationDetails> resolvedDependencies = context.handledNodes.get(ivyNode.getId());
        for (IvyNodeCallers.Caller caller : ivyNode.getCallers(context.conf)) {
            IvyNode parentNode;
            Set<String> dependencyConfigurationsForNode = this.getDependencyConfigurationsByCaller(ivyNode, caller);
            IvyNode ivyNode2 = parentNode = this.isRootCaller(context.configurationResolveReport, caller) ? ivyNode.getRoot() : context.configurationResolveReport.getDependency(caller.getModuleRevisionId());
            if (!this.isResolvedNode(parentNode, context.conf)) continue;
            Map<String, ConfigurationDetails> parentResolvedDependencies = context.handledNodes.get(parentNode.getId());
            if (parentResolvedDependencies == null) {
                throw new IllegalStateException(String.format("Could not find caller node %s for node %s. Available nodes: %s", parentNode.getId(), ivyNode.getId(), context.handledNodes.keySet()));
            }
            this.createAssociationsBetweenChildAndParentResolvedDependencies(ivyNode, resolvedDependencies, context.resolvedArtifacts, parentNode, caller, dependencyConfigurationsForNode, parentResolvedDependencies.values());
        }
    }

    private void constructConfigurationsForNode(IvyNode ivyNode, ReportConversionContext context) {
        LinkedHashMap<String, ConfigurationDetails> resolvedDependencies = new LinkedHashMap<String, ConfigurationDetails>();
        for (IvyNodeCallers.Caller caller : ivyNode.getCallers(context.conf)) {
            Set<String> dependencyConfigurationsForNode = this.getDependencyConfigurationsByCaller(ivyNode, caller);
            for (String dependencyConfiguration : dependencyConfigurationsForNode) {
                if (resolvedDependencies.containsKey(dependencyConfiguration)) continue;
                ConfigurationDetails configurationDetails = context.addConfiguration(ivyNode, dependencyConfiguration);
                context.resolvedArtifacts.addAll(configurationDetails.dependency.getModuleArtifacts());
                resolvedDependencies.put(dependencyConfiguration, configurationDetails);
            }
        }
        if (ivyNode == ivyNode.getRoot()) {
            ConfigurationDetails rootConfiguration = (ConfigurationDetails)resolvedDependencies.get(context.conf);
            if (rootConfiguration == null) {
                rootConfiguration = context.addConfiguration(ivyNode, context.conf);
                resolvedDependencies.put(context.conf, rootConfiguration);
            }
            context.root = rootConfiguration.dependency;
        }
        context.handledNodes.put(ivyNode.getId(), resolvedDependencies);
    }

    private void createAssociationsBetweenChildAndParentResolvedDependencies(IvyNode childNode, Map<String, ConfigurationDetails> childConfigurations, Set<ResolvedArtifact> resolvedArtifacts, IvyNode parentNode, IvyNodeCallers.Caller caller, Set<String> childConfigurationsToAttach, Collection<ConfigurationDetails> parentConfigurations) {
        for (String dependencyConfiguration : childConfigurationsToAttach) {
            Set<String> callerConfigurations = this.getCallerConfigurationsByDependencyConfiguration(caller, childNode, dependencyConfiguration);
            Set<ConfigurationDetails> parentCallerConfigurations = this.selectParentConfigurations(parentConfigurations, callerConfigurations);
            for (ConfigurationDetails parentConfiguration : parentCallerConfigurations) {
                ConfigurationDetails childConfiguration = childConfigurations.get(dependencyConfiguration);
                parentConfiguration.dependency.getChildren().add(childConfiguration.dependency);
                childConfiguration.dependency.getParents().add(parentConfiguration.dependency);
                Set<ResolvedArtifact> parentSpecificResolvedArtifacts = this.getParentSpecificArtifacts(childConfiguration.dependency, parentConfiguration.dependency.getConfiguration(), parentNode, caller, childNode);
                childConfiguration.dependency.addParentSpecificArtifacts(parentConfiguration.dependency, parentSpecificResolvedArtifacts);
                resolvedArtifacts.addAll(parentSpecificResolvedArtifacts);
            }
        }
    }

    private Set<ResolvedArtifact> getParentSpecificArtifacts(DefaultResolvedDependency resolvedDependency, String parentConfiguration, IvyNode callerNode, IvyNodeCallers.Caller caller, IvyNode childNode) {
        Set<String> parentConfigurations = this.getConfigurationHierarchy(callerNode, parentConfiguration);
        LinkedHashSet<DependencyArtifactDescriptor> parentArtifacts = new LinkedHashSet<DependencyArtifactDescriptor>();
        for (String configuration : parentConfigurations) {
            parentArtifacts.addAll(WrapUtil.toSet(caller.getDependencyDescriptor().getDependencyArtifacts(configuration)));
        }
        Artifact[] allArtifacts = childNode.getSelectedArtifacts(null);
        LinkedHashSet<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();
        block1: for (Artifact artifact : allArtifacts) {
            for (DependencyArtifactDescriptor parentArtifact : parentArtifacts) {
                if (!this.isEquals(parentArtifact, artifact)) continue;
                DefaultResolvedArtifact resolvedArtifact = this.createResolvedArtifact(artifact, childNode);
                resolvedArtifact.setResolvedDependency(resolvedDependency);
                artifacts.add(resolvedArtifact);
                continue block1;
            }
        }
        return artifacts;
    }

    private DefaultResolvedArtifact createResolvedArtifact(Artifact artifact, IvyNode ivyNode) {
        return new DefaultResolvedArtifact(artifact, ivyNode.getData().getEngine());
    }

    private boolean isEquals(DependencyArtifactDescriptor parentArtifact, Artifact artifact) {
        return parentArtifact.getName().equals(artifact.getName()) && parentArtifact.getExt().equals(artifact.getExt()) && parentArtifact.getType().equals(artifact.getType()) && ((Object)parentArtifact.getQualifiedExtraAttributes()).equals(artifact.getQualifiedExtraAttributes());
    }

    private boolean isRootCaller(ConfigurationResolveReport configurationResolveReport, IvyNodeCallers.Caller caller) {
        return caller.getModuleDescriptor().equals(configurationResolveReport.getModuleDescriptor());
    }

    private Set<ConfigurationDetails> selectParentConfigurations(Collection<ConfigurationDetails> parentConfigurations, Set<String> callerConfigurations) {
        LinkedHashSet<ConfigurationDetails> matchingParentConfigurations = new LinkedHashSet<ConfigurationDetails>();
        for (String callerConfiguration : callerConfigurations) {
            for (ConfigurationDetails parentConfiguration : parentConfigurations) {
                if (!parentConfiguration.containsConfiguration(callerConfiguration)) continue;
                matchingParentConfigurations.add(parentConfiguration);
            }
        }
        return matchingParentConfigurations;
    }

    private Set<String> getConfigurationHierarchy(IvyNode node, String configurationName) {
        LinkedHashSet<String> configurations = new LinkedHashSet<String>();
        configurations.add(configurationName);
        Configuration configuration = node.getConfiguration(configurationName);
        for (String extendedConfigurationNames : configuration.getExtends()) {
            configurations.addAll(this.getConfigurationHierarchy(node, extendedConfigurationNames));
        }
        return configurations;
    }

    private Set<String> getCallerConfigurationsByDependencyConfiguration(IvyNodeCallers.Caller caller, IvyNode dependencyNode, String dependencyConfiguration) {
        LinkedHashMap dependency2CallerConfs = new LinkedHashMap();
        for (String callerConf : caller.getCallerConfigurations()) {
            Set<String> dependencyConfs = this.getRealConfigurations(dependencyNode, caller.getDependencyDescriptor().getDependencyConfigurations(callerConf));
            for (String dependencyConf : dependencyConfs) {
                if (!dependency2CallerConfs.containsKey(dependencyConf)) {
                    dependency2CallerConfs.put(dependencyConf, new LinkedHashSet());
                }
                ((Set)dependency2CallerConfs.get(dependencyConf)).add(callerConf);
            }
        }
        return (Set)dependency2CallerConfs.get(dependencyConfiguration);
    }

    private Set<String> getDependencyConfigurationsByCaller(IvyNode dependencyNode, IvyNodeCallers.Caller caller) {
        String[] dependencyConfigurations = caller.getDependencyDescriptor().getDependencyConfigurations(caller.getCallerConfigurations());
        return this.getRealConfigurations(dependencyNode, dependencyConfigurations);
    }

    private Set<String> getRealConfigurations(IvyNode dependencyNode, String[] dependencyConfigurations) {
        LinkedHashSet<String> realDependencyConfigurations = new LinkedHashSet<String>();
        for (String dependencyConfiguration : dependencyConfigurations) {
            realDependencyConfigurations.addAll(WrapUtil.toSet(dependencyNode.getRealConfs(dependencyConfiguration)));
        }
        return realDependencyConfigurations;
    }

    private Set<ResolvedArtifact> getArtifacts(IvyNode dependencyNode) {
        Artifact[] artifacts;
        LinkedHashSet<ResolvedArtifact> resolvedArtifacts = new LinkedHashSet<ResolvedArtifact>();
        for (Artifact artifact : artifacts = dependencyNode.getSelectedArtifacts(null)) {
            resolvedArtifacts.add(this.createResolvedArtifact(artifact, dependencyNode));
        }
        return resolvedArtifacts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigurationDetails {
        final DefaultResolvedDependency dependency;
        final IvyNode node;
        final Set<String> configurationHierarchy;

        private ConfigurationDetails(DefaultResolvedDependency dependency, IvyNode node, Set<String> configurationHierarchy) {
            this.dependency = dependency;
            this.node = node;
            this.configurationHierarchy = configurationHierarchy;
        }

        public boolean containsConfiguration(String configuration) {
            return this.configurationHierarchy.contains(configuration);
        }

        public String toString() {
            return this.dependency.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReportConversionContext {
        ResolvedDependency root;
        final Map<Dependency, Set<ResolvedDependency>> firstLevelResolvedDependencies = new LinkedHashMap<Dependency, Set<ResolvedDependency>>();
        final Map<ModuleRevisionId, Map<String, ConfigurationDetails>> handledNodes = new LinkedHashMap<ModuleRevisionId, Map<String, ConfigurationDetails>>();
        final Set<ResolvedArtifact> resolvedArtifacts = new LinkedHashSet<ResolvedArtifact>();
        final ConfigurationResolveReport configurationResolveReport;
        final Map<ResolvedConfigurationIdentifier, ModuleDependency> firstLevelDependenciesModuleRevisionIds = new HashMap<ResolvedConfigurationIdentifier, ModuleDependency>();
        final Map<ResolvedConfigurationIdentifier, ConfigurationDetails> configurations = new HashMap<ResolvedConfigurationIdentifier, ConfigurationDetails>();
        final String conf;

        public ReportConversionContext(ResolveReport resolveReport, org.gradle.api.artifacts.Configuration configuration) {
            this.configurationResolveReport = resolveReport.getConfigurationReport(configuration.getName());
            this.createFirstLevelDependenciesModuleRevisionIds(configuration.getAllDependencies(ModuleDependency.class));
            this.conf = configuration.getName();
        }

        public ConfigurationDetails addConfiguration(IvyNode ivyNode, String configuration) {
            ModuleRevisionId actualId = ivyNode.getResolvedId();
            Set configurations = DefaultIvyReportConverter.this.getConfigurationHierarchy(ivyNode, configuration);
            DefaultResolvedDependency resolvedDependency = actualId.getAttribute("org.gradle.projectPath") != null ? new DefaultResolvedDependency(actualId.getAttribute("org.gradle.projectPath"), actualId.getOrganisation(), actualId.getName(), actualId.getRevision(), configuration, DefaultIvyReportConverter.this.getArtifacts(ivyNode)) : new DefaultResolvedDependency(actualId.getOrganisation(), actualId.getName(), actualId.getRevision(), configuration, DefaultIvyReportConverter.this.getArtifacts(ivyNode));
            for (ResolvedArtifact resolvedArtifact : resolvedDependency.getModuleArtifacts()) {
                ((DefaultResolvedArtifact)resolvedArtifact).setResolvedDependency(resolvedDependency);
            }
            ConfigurationDetails configurationDetails = new ConfigurationDetails(resolvedDependency, ivyNode, configurations);
            this.configurations.put(resolvedDependency.getId(), configurationDetails);
            ResolvedConfigurationIdentifier originalId = new ResolvedConfigurationIdentifier(ivyNode.getId(), configuration);
            if (this.firstLevelDependenciesModuleRevisionIds.containsKey(originalId)) {
                ModuleDependency firstLevelNode = this.firstLevelDependenciesModuleRevisionIds.get(originalId);
                this.firstLevelResolvedDependencies.get(firstLevelNode).add(resolvedDependency);
            }
            return configurationDetails;
        }

        private void createFirstLevelDependenciesModuleRevisionIds(Set<ModuleDependency> firstLevelDependencies) {
            for (ModuleDependency firstLevelDependency : firstLevelDependencies) {
                ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(DefaultIvyReportConverter.this.dependencyDescriptorFactory.createModuleRevisionId(firstLevelDependency), firstLevelDependency.getConfiguration());
                this.firstLevelDependenciesModuleRevisionIds.put(id, firstLevelDependency);
                this.firstLevelResolvedDependencies.put(firstLevelDependency, new LinkedHashSet());
            }
        }
    }
}

