/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.publish.PublishEngine;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyPublisher;
import org.gradle.api.internal.artifacts.ivyservice.PublishOptionsFactory;
import org.gradle.util.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyDependencyPublisher
implements IvyDependencyPublisher {
    public static final String FILE_PATH_EXTRA_ATTRIBUTE = "filePath";
    public static final List<String> ARTIFACT_PATTERN = WrapUtil.toList(String.format("[%s]", "filePath"));
    private static Logger logger = LoggerFactory.getLogger(DefaultIvyDependencyPublisher.class);
    private PublishOptionsFactory publishOptionsFactory;

    public DefaultIvyDependencyPublisher(PublishOptionsFactory publishOptionsFactory) {
        this.publishOptionsFactory = publishOptionsFactory;
    }

    @Override
    public void publish(Set<String> configurations, List<DependencyResolver> publishResolvers, ModuleDescriptor moduleDescriptor, File descriptorDestination, PublishEngine publishEngine) {
        try {
            for (DependencyResolver resolver : publishResolvers) {
                logger.info("Publishing to Resolver {}", (Object)resolver);
                publishEngine.publish(moduleDescriptor, ARTIFACT_PATTERN, resolver, this.publishOptionsFactory.createPublishOptions(configurations, descriptorDestination));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

