/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.DeleteOnExit;

public class ClientModuleResolver
extends BasicResolver {
    private Map moduleRegistry;
    private DependencyResolver userResolver;

    public ClientModuleResolver(String name, Map moduleRegistry, DependencyResolver userResolver) {
        this.setName(name);
        this.moduleRegistry = moduleRegistry;
        this.userResolver = userResolver;
        this.setRepositoryCacheManager(this.createUseOriginCacheManager(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedModuleRevision getDependency(DependencyDescriptor dde, ResolveData data) {
        if (dde.getExtraAttribute("org.gradle.clientModule") == null) {
            return null;
        }
        IvyContext context = IvyContext.pushNewCopyContext();
        try {
            context.setDependencyDescriptor(dde);
            context.setResolveData(data);
            DefaultModuleDescriptor moduleDescriptor = (DefaultModuleDescriptor)this.moduleRegistry.get(dde.getExtraAttribute("org.gradle.clientModule"));
            MetadataArtifactDownloadReport downloadReport = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
            downloadReport.setDownloadStatus(DownloadStatus.NO);
            downloadReport.setSearched(false);
            ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision(this.userResolver, this.userResolver, (ModuleDescriptor)moduleDescriptor, downloadReport);
            return resolvedModuleRevision;
        }
        finally {
            IvyContext.popContext();
        }
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        return null;
    }

    protected Collection findNames(Map tokenValues, String token) {
        return null;
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        return null;
    }

    protected long get(Resource resource, File dest) {
        return resource.getContentLength();
    }

    protected Resource getResource(String s) {
        return null;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) {
    }

    private RepositoryCacheManager createUseOriginCacheManager(String name) {
        File tmpIvyCache = this.createTmpDir();
        DefaultRepositoryCacheManager cacheManager = new DefaultRepositoryCacheManager();
        cacheManager.setBasedir(tmpIvyCache);
        cacheManager.setName(name);
        cacheManager.setUseOrigin(true);
        cacheManager.setLockStrategy((LockStrategy)new NoLockStrategy());
        cacheManager.setIvyPattern("[organisation]/[module](/[branch])/ivy-[revision].xml");
        cacheManager.setArtifactPattern("[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])");
        return cacheManager;
    }

    private File createTmpDir() {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("gradle_ivy_cache_" + this.getName(), "");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        tmpFile.delete();
        tmpFile.mkdir();
        DeleteOnExit.addFile(tmpFile);
        return tmpFile;
    }
}

