/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClientModule
extends AbstractExternalDependency
implements ClientModule {
    private String group;
    private String name;
    private String version;
    private boolean force;
    private Set<ModuleDependency> dependencies = new HashSet<ModuleDependency>();

    public DefaultClientModule(String group, String name, String version) {
        this(group, name, version, null);
    }

    public DefaultClientModule(String group, String name, String version, String configuration) {
        super(configuration);
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        this.group = group;
        this.name = name;
        this.version = version;
    }

    private String emptyStringIfNull(String value) {
        return value == null ? "" : value;
    }

    @Override
    public Set<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getId() {
        return this.emptyStringIfNull(this.group) + ":" + this.emptyStringIfNull(this.name) + ":" + this.emptyStringIfNull(this.version);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public ClientModule setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ClientModule setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public ClientModule setVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public ClientModule setForce(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public void addDependency(ModuleDependency dependency) {
        this.dependencies.add(dependency);
    }

    @Override
    public ClientModule copy() {
        DefaultClientModule copiedClientModule = new DefaultClientModule(this.getGroup(), this.getName(), this.getVersion(), this.getConfiguration());
        this.copyTo(copiedClientModule);
        for (ModuleDependency dependency : this.dependencies) {
            copiedClientModule.addDependency(dependency.copy());
        }
        return copiedClientModule;
    }

    @Override
    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || this.getClass() != dependency.getClass()) {
            return false;
        }
        ClientModule that = (ClientModule)dependency;
        if (!this.isContentEqualsFor(that)) {
            return false;
        }
        return ((Object)this.dependencies).equals(that.getDependencies());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientModule that = (ClientModule)o;
        return this.isKeyEquals(that);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

