/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectContainer;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.IvyService;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
extends AbstractFileCollection
implements Configuration {
    private final String path;
    private final String name;
    private Configuration.Visibility visibility = Configuration.Visibility.PUBLIC;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private ConfigurationsProvider configurationsProvider;
    private IvyService ivyService;
    private DefaultDomainObjectContainer<Dependency> dependencies = new DefaultDomainObjectContainer<Dependency>(Dependency.class);
    private Set<PublishArtifact> artifacts = new LinkedHashSet<PublishArtifact>();
    private Set<ExcludeRule> excludeRules = new LinkedHashSet<ExcludeRule>();
    private final ConfigurationTaskDependency taskDependency = new ConfigurationTaskDependency();
    private final Object lock = new Object();
    private Configuration.State state = Configuration.State.UNRESOLVED;
    private ResolvedConfiguration cachedResolvedConfiguration;

    public DefaultConfiguration(String path, String name, ConfigurationsProvider configurationsProvider, IvyService ivyService) {
        this.path = path;
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.ivyService = ivyService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration.State getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visibility == Configuration.Visibility.PUBLIC;
    }

    @Override
    public Configuration setVisible(boolean visible) {
        this.throwExceptionIfNotInUnresolvedState();
        this.visibility = visible ? Configuration.Visibility.PUBLIC : Configuration.Visibility.PRIVATE;
        return this;
    }

    @Override
    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    @Override
    public Configuration setExtendsFrom(Set<Configuration> extendsFrom) {
        this.throwExceptionIfNotInUnresolvedState();
        this.extendsFrom = new HashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    @Override
    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.throwExceptionIfNotInUnresolvedState();
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            this.extendsFrom.add(configuration);
        }
        return this;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Configuration setTransitive(boolean transitive) {
        this.throwExceptionIfNotInUnresolvedState();
        this.transitive = transitive;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Configuration setDescription(String description) {
        this.throwExceptionIfNotInUnresolvedState();
        this.description = description;
        return this;
    }

    @Override
    public Set<Configuration> getHierarchy() {
        Set<Configuration> result = WrapUtil.toLinkedSet(this);
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            if (result.contains(superConfig)) {
                result.remove(superConfig);
            }
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    @Override
    public Set<Configuration> getAll() {
        return this.configurationsProvider.getAll();
    }

    @Override
    public Set<File> resolve() {
        return this.getFiles();
    }

    @Override
    public Set<File> getFiles() {
        return this.fileCollection(Specs.SATISFIES_ALL).getFiles();
    }

    @Override
    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    @Override
    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    @Override
    public Set<File> files(Spec<Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    @Override
    public FileCollection fileCollection(Spec<Dependency> dependencySpec) {
        return new ConfigurationFileCollection(dependencySpec);
    }

    @Override
    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return new ConfigurationFileCollection(dependencySpecClosure);
    }

    @Override
    public FileCollection fileCollection(Dependency ... dependencies) {
        return new ConfigurationFileCollection(WrapUtil.toLinkedSet(dependencies));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == Configuration.State.UNRESOLVED) {
                this.cachedResolvedConfiguration = this.ivyService.resolve(this);
                this.state = this.cachedResolvedConfiguration.hasError() ? Configuration.State.RESOLVED_WITH_FAILURES : Configuration.State.RESOLVED;
            }
            return this.cachedResolvedConfiguration;
        }
    }

    @Override
    public void publish(List<DependencyResolver> publishResolvers, File descriptorDestination) {
        this.ivyService.publish(this.getHierarchy(), descriptorDestination, publishResolvers);
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.taskDependency;
    }

    @Override
    public TaskDependency getTaskDependencyFromProjectDependency(final boolean useDependedOn, final String taskName) {
        return new AbstractTaskDependency(){

            public void resolve(TaskDependencyResolveContext context) {
                if (useDependedOn) {
                    this.addTaskDependenciesFromProjectsIDependOn(taskName, context);
                } else {
                    Project thisProject = context.getTask().getProject();
                    this.addTaskDependenciesFromProjectsDependingOnMe(thisProject, taskName, context);
                }
            }

            private void addTaskDependenciesFromProjectsIDependOn(String taskName2, TaskDependencyResolveContext context) {
                Set<ProjectDependency> projectDependencies = DefaultConfiguration.this.getAllDependencies(ProjectDependency.class);
                for (ProjectDependency projectDependency : projectDependencies) {
                    Task nextTask = (Task)projectDependency.getDependencyProject().getTasks().findByName(taskName2);
                    if (nextTask == null) continue;
                    context.add(nextTask);
                }
            }

            private void addTaskDependenciesFromProjectsDependingOnMe(Project thisProject, String taskName2, TaskDependencyResolveContext context) {
                Set<Task> tasksWithName = thisProject.getRootProject().getTasksByName(taskName2, true);
                for (Task nextTask : tasksWithName) {
                    Configuration configuration = (Configuration)nextTask.getProject().getConfigurations().findByName(DefaultConfiguration.this.getName());
                    if (configuration == null || !DefaultConfiguration.doesConfigurationDependOnProject(configuration, thisProject)) continue;
                    context.add(nextTask);
                }
            }
        };
    }

    private static boolean doesConfigurationDependOnProject(Configuration configuration, Project project) {
        Set<ProjectDependency> projectDependencies = configuration.getAllDependencies(ProjectDependency.class);
        for (ProjectDependency projectDependency : projectDependencies) {
            if (!projectDependency.getDependencyProject().equals(project)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TaskDependency getBuildArtifacts() {
        return this.getAllArtifactFiles().getBuildDependencies();
    }

    @Override
    public Set<Dependency> getDependencies() {
        return this.dependencies.getAll();
    }

    @Override
    public Set<Dependency> getAllDependencies() {
        return Configurations.getDependencies(this.getHierarchy(), Specs.<Dependency>satisfyAll());
    }

    @Override
    public <T extends Dependency> Set<T> getDependencies(Class<T> type) {
        return this.filter(type, this.getDependencies());
    }

    private <T extends Dependency> Set<T> filter(Class<T> type, Set<Dependency> dependencySet) {
        LinkedHashSet<T> matches = new LinkedHashSet<T>();
        for (Dependency dependency : dependencySet) {
            if (!type.isInstance(dependency)) continue;
            matches.add(type.cast(dependency));
        }
        return matches;
    }

    @Override
    public <T extends Dependency> Set<T> getAllDependencies(Class<T> type) {
        return this.filter(type, this.getAllDependencies());
    }

    @Override
    public void addDependency(Dependency dependency) {
        this.throwExceptionIfNotInUnresolvedState();
        this.dependencies.addObject(dependency);
    }

    @Override
    public Configuration addArtifact(PublishArtifact artifact) {
        this.throwExceptionIfNotInUnresolvedState();
        this.artifacts.add(artifact);
        return this;
    }

    @Override
    public Configuration removeArtifact(PublishArtifact artifact) {
        this.throwExceptionIfNotInUnresolvedState();
        this.artifacts.remove(artifact);
        return this;
    }

    @Override
    public Set<PublishArtifact> getArtifacts() {
        return Collections.unmodifiableSet(this.artifacts);
    }

    @Override
    public Set<PublishArtifact> getAllArtifacts() {
        return Configurations.getArtifacts(this.getHierarchy(), Specs.SATISFIES_ALL);
    }

    @Override
    public FileCollection getAllArtifactFiles() {
        return new ArtifactsFileCollection();
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        return Collections.unmodifiableSet(this.excludeRules);
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules = excludeRules;
    }

    @Override
    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.throwExceptionIfNotInUnresolvedState();
        this.excludeRules.add(new DefaultExcludeRule(excludeRuleArgs));
        return this;
    }

    @Override
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConfiguration that = (DefaultConfiguration)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String getDisplayName() {
        return String.format("configuration '%s'", this.path);
    }

    public Configuration getConfiguration(Dependency dependency) {
        for (Configuration configuration : this.getHierarchy()) {
            if (!configuration.getDependencies().contains(dependency)) continue;
            return configuration;
        }
        return null;
    }

    @Override
    public Configuration copy() {
        return this.createCopy(this.getDependencies());
    }

    @Override
    public Configuration copyRecursive() {
        return this.createCopy(this.getAllDependencies());
    }

    @Override
    public Configuration copy(Spec<Dependency> dependencySpec) {
        return this.createCopy(Specs.filterIterable(this.getDependencies(), dependencySpec));
    }

    @Override
    public Configuration copyRecursive(Spec<Dependency> dependencySpec) {
        return this.createCopy(Specs.filterIterable(this.getAllDependencies(), dependencySpec));
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies) {
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration copiedConfiguration = new DefaultConfiguration(this.path + "Copy", this.name + "Copy", configurationsProvider, this.ivyService);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        copiedConfiguration.visibility = this.visibility;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        for (PublishArtifact artifact : this.getAllArtifacts()) {
            copiedConfiguration.addArtifact(artifact);
        }
        for (ExcludeRule excludeRule : this.getExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getExcludeArgs()));
        }
        for (Dependency dependency : dependencies) {
            copiedConfiguration.addDependency(dependency.copy());
        }
        return copiedConfiguration;
    }

    @Override
    public Configuration copy(Closure dependencySpec) {
        return this.copy(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive(Specs.convertClosureToSpec(dependencySpec));
    }

    private void throwExceptionIfNotInUnresolvedState() {
        if (this.getState() != Configuration.State.UNRESOLVED) {
            throw new InvalidUserDataException("You can't change a configuration which is not in unresolved state!");
        }
    }

    public Action<? super Dependency> whenDependencyAdded(Action<? super Dependency> action) {
        return this.dependencies.whenObjectAdded(action);
    }

    public void whenDependencyAdded(Closure closure) {
        this.dependencies.whenObjectAdded(closure);
    }

    public void allDependencies(Action<? super Dependency> action) {
        this.dependencies.all(action);
    }

    public void allDependencies(Closure action) {
        this.dependencies.all(action);
    }

    private class ConfigurationTaskDependency
    extends AbstractTaskDependency {
        private ConfigurationTaskDependency() {
        }

        public String toString() {
            return String.format("build dependencies %s", DefaultConfiguration.this);
        }

        public void resolve(TaskDependencyResolveContext context) {
            for (Configuration configuration : DefaultConfiguration.this.getExtendsFrom()) {
                context.add(configuration);
            }
            for (SelfResolvingDependency dependency : DefaultConfiguration.this.getDependencies(SelfResolvingDependency.class)) {
                context.add(dependency);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigurationFileCollection
    extends AbstractFileCollection {
        private Spec<Dependency> dependencySpec;

        private ConfigurationFileCollection(Spec<Dependency> dependencySpec) {
            this.dependencySpec = dependencySpec;
        }

        public ConfigurationFileCollection(Closure dependencySpecClosure) {
            this.dependencySpec = Specs.convertClosureToSpec(dependencySpecClosure);
        }

        public ConfigurationFileCollection(final Set<Dependency> dependencies) {
            this.dependencySpec = new Spec<Dependency>(){

                @Override
                public boolean isSatisfiedBy(Dependency element) {
                    return dependencies.contains(element);
                }
            };
        }

        public Spec<Dependency> getDependencySpec() {
            return this.dependencySpec;
        }

        @Override
        public String getDisplayName() {
            return String.format("%s dependencies", DefaultConfiguration.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<File> getFiles() {
            Object object = DefaultConfiguration.this.lock;
            synchronized (object) {
                ResolvedConfiguration resolvedConfiguration = DefaultConfiguration.this.getResolvedConfiguration();
                if (DefaultConfiguration.this.getState() == Configuration.State.RESOLVED_WITH_FAILURES) {
                    resolvedConfiguration.rethrowFailure();
                }
                return resolvedConfiguration.getFiles(this.dependencySpec);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArtifactsFileCollection
    extends AbstractFileCollection {
        private final TaskDependencyInternal taskDependency = new AbstractTaskDependency(){

            public void resolve(TaskDependencyResolveContext context) {
                for (Configuration configuration : DefaultConfiguration.this.getExtendsFrom()) {
                    context.add(configuration.getBuildArtifacts());
                }
                for (PublishArtifact publishArtifact : DefaultConfiguration.this.getArtifacts()) {
                    context.add(publishArtifact);
                }
            }
        };

        ArtifactsFileCollection() {
        }

        @Override
        public String getDisplayName() {
            return String.format("%s artifacts", DefaultConfiguration.this);
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return this.taskDependency;
        }

        @Override
        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (PublishArtifact artifact : DefaultConfiguration.this.getAllArtifacts()) {
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

