/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurations {
    public static Set<String> getNames(Collection<Configuration> configurations, boolean includeExtended) {
        Set<Configuration> allConfigurations = new HashSet<Configuration>(configurations);
        if (includeExtended) {
            allConfigurations = Configurations.createAllConfigurations(configurations);
        }
        HashSet<String> names = new HashSet<String>();
        for (Configuration configuration : allConfigurations) {
            names.add(configuration.getName());
        }
        return names;
    }

    public static Set<String> getNames(Collection<Configuration> configurations) {
        return Configurations.getNames(configurations, false);
    }

    private static Set<Configuration> createAllConfigurations(Collection<Configuration> configurations) {
        HashSet<Configuration> allConfigurations = new HashSet<Configuration>();
        for (Configuration configuration : configurations) {
            allConfigurations.addAll(configuration.getHierarchy());
        }
        return allConfigurations;
    }

    public static String uploadInternalTaskName(String configurationName) {
        return String.format("upload%sInternal", Configurations.getCapitalName(configurationName));
    }

    public static String uploadTaskName(String configurationName) {
        return String.format("upload%s", Configurations.getCapitalName(configurationName));
    }

    private static String getCapitalName(String configurationName) {
        return configurationName.substring(0, 1).toUpperCase() + configurationName.substring(1);
    }

    public static Set<Dependency> getDependencies(Set<Configuration> configurations, Spec<Dependency> dependencySpec) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (Configuration configuration : configurations) {
            for (Dependency dependency : configuration.getDependencies()) {
                if (!dependencySpec.isSatisfiedBy(dependency)) continue;
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    public static Set<PublishArtifact> getArtifacts(Set<Configuration> configurations, Spec<PublishArtifact> artifactSpec) {
        HashSet<PublishArtifact> artifacts = new HashSet<PublishArtifact>();
        for (Configuration configuration : configurations) {
            for (PublishArtifact artifact : configuration.getArtifacts()) {
                if (!artifactSpec.isSatisfiedBy(artifact)) continue;
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }
}

