/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.apache.ivy.core.module.id.ModuleRevisionId;

public class ResolvedConfigurationIdentifier {
    private final String moduleGroup;
    private final String moduleName;
    private final String moduleVersion;
    private final String configuration;

    public ResolvedConfigurationIdentifier(String moduleGroup, String moduleName, String moduleVersion, String configuration) {
        this.moduleGroup = moduleGroup;
        this.moduleName = moduleName;
        this.moduleVersion = moduleVersion;
        this.configuration = configuration;
    }

    public ResolvedConfigurationIdentifier(ModuleRevisionId moduleRevisionId, String configuration) {
        this(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision(), configuration);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getModuleGroup() {
        return this.moduleGroup;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.moduleGroup, this.moduleName, this.moduleVersion, this.configuration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedConfigurationIdentifier that = (ResolvedConfigurationIdentifier)o;
        if (!this.moduleGroup.equals(that.moduleGroup)) {
            return false;
        }
        if (!this.moduleName.equals(that.moduleName)) {
            return false;
        }
        if (!this.moduleVersion.equals(that.moduleVersion)) {
            return false;
        }
        return this.configuration.equals(that.configuration);
    }

    public int hashCode() {
        return this.moduleGroup.hashCode() ^ this.moduleName.hashCode() ^ this.configuration.hashCode();
    }
}

