/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaMethod;
import java.lang.reflect.Constructor;
import java.util.Formatter;
import org.gradle.api.internal.AbstractClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovySourceGenerationBackedClassGenerator
extends AbstractClassGenerator {
    @Override
    protected <T> AbstractClassGenerator.ClassBuilder<T> start(Class<T> type) {
        return new ClassBuilderImpl(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassBuilderImpl<T>
    implements AbstractClassGenerator.ClassBuilder<T> {
        private final Formatter src;
        private final Class<T> type;
        private final String className;
        private boolean dynamicAware;

        private ClassBuilderImpl(Class<T> type) {
            this.className = type.getSimpleName() + "_Generated";
            this.src = new Formatter();
            this.type = type;
        }

        @Override
        public void startClass(boolean isConventionAware, boolean isDynamicAware) {
            this.dynamicAware = isDynamicAware;
            if (this.type.getPackage() != null) {
                this.src.format("package %s;%n", this.type.getPackage().getName());
            }
            this.src.format("public class %s extends %s ", this.className, this.type.getName().replaceAll("\\$", "."));
            if (isConventionAware) {
                this.src.format("implements org.gradle.api.internal.IConventionAware ", new Object[0]);
            }
            if (isDynamicAware) {
                this.src.format(isConventionAware ? ", " : "implements ", new Object[0]);
                this.src.format("org.gradle.api.internal.DynamicObjectAware ", new Object[0]);
            }
            this.src.format("{%n", new Object[0]);
        }

        @Override
        public void addConstructor(Constructor<?> constructor) {
            int i;
            this.src.format("public %s(", this.className);
            for (i = 0; i < constructor.getParameterTypes().length; ++i) {
                Class<?> paramType = constructor.getParameterTypes()[i];
                if (i > 0) {
                    this.src.format(",", new Object[0]);
                }
                this.src.format("%s p%d", paramType.getCanonicalName(), i);
            }
            this.src.format(") { super(", new Object[0]);
            for (i = 0; i < constructor.getParameterTypes().length; ++i) {
                if (i > 0) {
                    this.src.format(",", new Object[0]);
                }
                this.src.format("p%d", i);
            }
            this.src.format("); }%n", new Object[0]);
        }

        @Override
        public void mixInDynamicAware() {
            this.src.format("private org.gradle.api.internal.DynamicObjectHelper dynamicObject = new org.gradle.api.internal.DynamicObjectHelper(this, new org.gradle.api.internal.plugins.DefaultConvention())%n", new Object[0]);
            this.src.format("public void setConvention(org.gradle.api.plugins.Convention convention) { dynamicObject.setConvention(convention); getConventionMapping().setConvention(convention) }%n", new Object[0]);
            this.src.format("public org.gradle.api.plugins.Convention getConvention() { return dynamicObject.getConvention() }%n", new Object[0]);
            this.src.format("public org.gradle.api.internal.DynamicObject getAsDynamicObject() { return dynamicObject }%n", new Object[0]);
        }

        @Override
        public void mixInConventionAware() {
            if (this.dynamicAware) {
                this.src.format("private org.gradle.api.internal.ConventionMapping mapping = new org.gradle.api.internal.ConventionAwareHelper(this, getConvention())%n", new Object[0]);
            } else {
                this.src.format("private org.gradle.api.internal.ConventionMapping mapping = new org.gradle.api.internal.ConventionAwareHelper(this, new org.gradle.api.internal.plugins.DefaultConvention())%n", new Object[0]);
            }
            this.src.format("public void setConventionMapping(org.gradle.api.internal.ConventionMapping conventionMapping) { this.mapping = conventionMapping }%n", new Object[0]);
            this.src.format("public org.gradle.api.internal.ConventionMapping getConventionMapping() { return mapping }%n", new Object[0]);
        }

        @Override
        public void mixInGroovyObject() {
        }

        @Override
        public void addDynamicMethods() {
            this.src.format("def hasProperty(String name) { getAsDynamicObject().hasProperty(name); }%n", new Object[0]);
            this.src.format("void setProperty(String name, Object value) { getAsDynamicObject().setProperty(name, value); }%n", new Object[0]);
            this.src.format("def propertyMissing(String name) { getAsDynamicObject().getProperty(name); }%n", new Object[0]);
            this.src.format("def methodMissing(String name, Object params) { getAsDynamicObject().invokeMethod(name, (Object[])params); }%n", new Object[0]);
        }

        @Override
        public void addGetter(MetaBeanProperty property) {
            MetaMethod getter = property.getGetter();
            String returnTypeName = getter.getReturnType().getCanonicalName();
            this.src.format("private boolean %sSet;%n", property.getName());
            this.src.format("public %s %s() { getConventionMapping().getConventionValue(super.%s(), '%s', %sSet); }%n", returnTypeName, getter.getName(), getter.getName(), property.getName(), property.getName());
        }

        @Override
        public void addSetter(MetaBeanProperty property) throws Exception {
            MetaMethod setter = property.getSetter();
            if (setter.getReturnType().equals(Void.TYPE)) {
                this.src.format("public void %s(%s v) { super.%s(v); %sSet = true; }%n", setter.getName(), setter.getParameterTypes()[0].getTheClass().getCanonicalName(), setter.getName(), property.getName());
            } else {
                String returnTypeName = setter.getReturnType().getCanonicalName();
                this.src.format("public %s %s(%s v) { %s r = super.%s(v); %sSet = true; return r; }%n", returnTypeName, setter.getName(), setter.getParameterTypes()[0].getTheClass().getCanonicalName(), returnTypeName, setter.getName(), property.getName());
            }
        }

        @Override
        public Class<? extends T> generate() {
            this.src.format("}", new Object[0]);
            GroovyClassLoader classLoader = new GroovyClassLoader(this.type.getClassLoader());
            return classLoader.parseClass(this.src.toString());
        }
    }
}

