/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.internal.AbstractDynamicObject;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.internal.CompositeDynamicObject;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.MapBackedDynamicObject;
import org.gradle.api.plugins.Convention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicObjectHelper
extends CompositeDynamicObject {
    private final AbstractDynamicObject delegateObject;
    private DynamicObject parent;
    private Convention convention;
    private DynamicObject beforeConvention;
    private DynamicObject afterConvention;
    private MapBackedDynamicObject additionalProperties;

    public DynamicObjectHelper(Object delegateObject) {
        this(new BeanDynamicObject(delegateObject), null);
    }

    public DynamicObjectHelper(Object delegateObject, Convention convention) {
        this(new BeanDynamicObject(delegateObject), convention);
    }

    public DynamicObjectHelper(AbstractDynamicObject delegateObject, Convention convention) {
        this.delegateObject = delegateObject;
        this.additionalProperties = new MapBackedDynamicObject(delegateObject);
        this.setConvention(convention);
    }

    private void updateDelegates() {
        ArrayList<DynamicObject> delegates = new ArrayList<DynamicObject>();
        delegates.add(this.delegateObject);
        delegates.add(this.additionalProperties);
        if (this.beforeConvention != null) {
            delegates.add(this.beforeConvention);
        }
        if (this.convention != null) {
            delegates.add(this.convention);
        }
        if (this.afterConvention != null) {
            delegates.add(this.afterConvention);
        }
        if (this.parent != null) {
            delegates.add(this.parent);
        }
        this.setObjects(delegates.toArray(new DynamicObject[delegates.size()]));
        delegates.remove(this.parent);
        delegates.add(this.additionalProperties);
        this.setObjectsForUpdate(delegates.toArray(new DynamicObject[delegates.size()]));
    }

    @Override
    protected String getDisplayName() {
        return this.delegateObject.getDisplayName();
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties.getProperties();
    }

    public DynamicObject getParent() {
        return this.parent;
    }

    public void setParent(DynamicObject parent) {
        this.parent = parent;
        this.updateDelegates();
    }

    public Convention getConvention() {
        return this.convention;
    }

    public void setConvention(Convention convention) {
        this.convention = convention;
        this.updateDelegates();
    }

    public void addObject(DynamicObject object, Location location) {
        switch (location) {
            case BeforeConvention: {
                this.beforeConvention = object;
                break;
            }
            case AfterConvention: {
                this.afterConvention = object;
            }
        }
        this.updateDelegates();
    }

    public DynamicObject getInheritable() {
        return new InheritedDynamicObject();
    }

    private DynamicObjectHelper snapshotInheritable() {
        AbstractDynamicObject emptyBean = new AbstractDynamicObject(){

            protected String getDisplayName() {
                return DynamicObjectHelper.this.delegateObject.getDisplayName();
            }
        };
        DynamicObjectHelper helper = new DynamicObjectHelper(emptyBean);
        helper.parent = this.parent;
        helper.convention = this.convention;
        helper.additionalProperties = this.additionalProperties;
        if (this.beforeConvention != null) {
            helper.beforeConvention = this.beforeConvention;
        }
        helper.updateDelegates();
        return helper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InheritedDynamicObject
    implements DynamicObject {
        private InheritedDynamicObject() {
        }

        @Override
        public void setProperty(String name, Object value) {
            throw new MissingPropertyException(String.format("Could not find property '%s' inherited from %s.", name, DynamicObjectHelper.this.delegateObject.getDisplayName()));
        }

        @Override
        public boolean hasProperty(String name) {
            return DynamicObjectHelper.this.snapshotInheritable().hasProperty(name);
        }

        @Override
        public Object getProperty(String name) {
            return DynamicObjectHelper.this.snapshotInheritable().getProperty(name);
        }

        public Map<String, Object> getProperties() {
            return DynamicObjectHelper.this.snapshotInheritable().getProperties();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return DynamicObjectHelper.this.snapshotInheritable().hasMethod(name, arguments);
        }

        @Override
        public Object invokeMethod(String name, Object ... arguments) {
            return DynamicObjectHelper.this.snapshotInheritable().invokeMethod(name, arguments);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        BeforeConvention,
        AfterConvention;

    }
}

