/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.AbstractDomainObjectCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.listener.ActionBroadcast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDomainObjectContainer<T>
extends AbstractDomainObjectCollection<T> {
    private final Class<T> type;
    private final ObjectStore<T> store;

    public DefaultDomainObjectContainer(Class<T> type) {
        this(type, new SetStore());
    }

    protected DefaultDomainObjectContainer(Class<T> type, ObjectStore<T> store) {
        super(store);
        this.type = type;
        this.store = store;
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public DomainObjectCollection<T> matching(Spec<? super T> spec) {
        return new DefaultDomainObjectContainer<T>(this.type, this.storeWithSpec(spec));
    }

    @Override
    public DomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec(spec));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type) {
        return new DefaultDomainObjectContainer<S>(type, this.storeWithType(type));
    }

    protected ObjectStore<T> storeWithSpec(Spec<? super T> spec) {
        return new FilteredObjectStore<T>(this.store, this.type, spec);
    }

    protected <S extends T> ObjectStore<S> storeWithType(Class<S> type) {
        return new FilteredObjectStore<T>(this.store, type, Specs.satisfyAll());
    }

    public void addObject(T value) {
        this.store.add(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredObjectStore<S>
    extends AbstractDomainObjectCollection.FilteredStore<S>
    implements ObjectStore<S> {
        public FilteredObjectStore(ObjectStore<? super S> store, Class<S> type, Spec<? super S> spec) {
            super(store, type, spec);
        }

        @Override
        public void add(S object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetStore<S>
    implements ObjectStore<S> {
        private final ActionBroadcast<S> addActions = new ActionBroadcast();
        private final ActionBroadcast<S> removeActions = new ActionBroadcast();
        private final Map<S, S> objects = new LinkedHashMap<S, S>();

        private SetStore() {
        }

        @Override
        public void add(S object) {
            S oldValue = this.objects.put(object, object);
            if (oldValue != null) {
                this.removeActions.execute(oldValue);
            }
            this.addActions.execute(object);
        }

        @Override
        public Collection<? extends S> getAll() {
            return this.objects.values();
        }

        @Override
        public void objectAdded(Action<? super S> action) {
            this.addActions.add(action);
        }

        @Override
        public void objectRemoved(Action<? super S> action) {
            this.removeActions.add(action);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ObjectStore<S>
    extends AbstractDomainObjectCollection.Store<S> {
        public void add(S var1);
    }
}

