/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.DefaultClassPathProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassPathRegistry
implements ClassPathRegistry {
    private final List<ClassPathProvider> providers = new ArrayList<ClassPathProvider>();

    public DefaultClassPathRegistry(ClassPathProvider ... providers) {
        this.providers.addAll(Arrays.asList(providers));
        this.providers.add(new DefaultClassPathProvider());
    }

    @Override
    public URL[] getClassPathUrls(String name) {
        return this.toURLArray(this.getClassPathFiles(name));
    }

    @Override
    public Set<URL> getClassPath(String name) {
        return this.toUrlSet(this.getClassPathFiles(name));
    }

    @Override
    public Set<File> getClassPathFiles(String name) {
        for (ClassPathProvider provider : this.providers) {
            Set<File> classpath = provider.findClassPath(name);
            if (classpath == null) continue;
            return classpath;
        }
        throw new IllegalArgumentException(String.format("unknown classpath '%s' requested.", name));
    }

    private Set<URL> toUrlSet(Set<File> classPathFiles) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (File file : classPathFiles) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }
        return urls;
    }

    private URL[] toURLArray(Collection<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

