/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.artifacts;

import java.io.File;
import org.gradle.api.InvalidUserDataException;

public class PublishInstruction {
    private boolean uploadDescriptor;
    private File descriptorDestination;

    public PublishInstruction() {
        this.uploadDescriptor = false;
        this.descriptorDestination = null;
    }

    public PublishInstruction(boolean uploadDescriptor, File descriptorDestination) {
        if (uploadDescriptor && descriptorDestination == null) {
            throw new InvalidUserDataException("You must specify a module descriptor destination, if a module descriptor should be uploaded.");
        }
        if (!uploadDescriptor && descriptorDestination != null) {
            throw new InvalidUserDataException("You must not specify a module descriptor destination, if a module descriptor should not be uploaded.");
        }
        this.uploadDescriptor = uploadDescriptor;
        this.descriptorDestination = descriptorDestination;
    }

    public boolean isUploadDescriptor() {
        return this.uploadDescriptor;
    }

    public File getDescriptorDestination() {
        return this.descriptorDestination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishInstruction that = (PublishInstruction)o;
        if (this.uploadDescriptor != that.uploadDescriptor) {
            return false;
        }
        return !(this.descriptorDestination != null ? !this.descriptorDestination.equals(that.descriptorDestination) : that.descriptorDestination != null);
    }

    public int hashCode() {
        int result = this.uploadDescriptor ? 1 : 0;
        result = 31 * result + (this.descriptorDestination != null ? this.descriptorDestination.hashCode() : 0);
        return result;
    }
}

