/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class TaskExecutionLogger
implements TaskExecutionListener {
    private ProgressLogger currentTask;
    private final ProgressLoggerFactory progressLoggerFactory;

    public TaskExecutionLogger(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public void beforeExecute(Task task) {
        assert (this.currentTask == null);
        this.currentTask = this.progressLoggerFactory.start(TaskExecutionLogger.class.getName(), this.getDisplayName(task));
        this.currentTask.progress(this.getDisplayName(task));
    }

    public void afterExecute(Task task, TaskState state) {
        if (state.getSkipMessage() != null) {
            this.currentTask.completed(state.getSkipMessage());
        } else {
            this.currentTask.completed();
        }
        this.currentTask = null;
    }

    private String getDisplayName(Task task) {
        Gradle build = task.getProject().getGradle();
        if (build.getParent() == null) {
            return task.getPath();
        }
        return ":" + build.getRootProject().getName() + task.getPath();
    }
}

