/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.CacheUsage;
import org.gradle.api.internal.artifacts.ProjectDependenciesBuildInstruction;
import org.gradle.api.logging.LogLevel;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.DefaultBuildExecuter;
import org.gradle.execution.DryRunBuildExecuter;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.initialization.BuildFileProjectSpec;
import org.gradle.initialization.DefaultProjectSpec;
import org.gradle.initialization.ProjectDirectoryProjectSpec;
import org.gradle.initialization.ProjectSpec;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartParameter {
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    public static final File DEFAULT_GRADLE_USER_HOME = new File(System.getProperty("user.home") + "/.gradle");
    private List<String> taskNames = new ArrayList<String>();
    private Set<String> excludedTaskNames = new HashSet<String>();
    private ProjectDependenciesBuildInstruction projectDependenciesBuildInstruction = new ProjectDependenciesBuildInstruction(true);
    private File currentDir;
    private boolean searchUpwards = true;
    private Map<String, String> projectProperties = new HashMap<String, String>();
    private Map<String, String> systemPropertiesArgs = new HashMap<String, String>();
    private File gradleUserHomeDir;
    private CacheUsage cacheUsage = CacheUsage.ON;
    private ScriptSource buildScriptSource;
    private ScriptSource settingsScriptSource;
    private BuildExecuter buildExecuter;
    private ProjectSpec defaultProjectSelector;
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private ShowStacktrace showStacktrace = ShowStacktrace.INTERNAL_EXCEPTIONS;
    private File buildFile;
    private List<File> initScripts = new ArrayList<File>();
    private boolean dryRun;
    private boolean noOpt;
    private boolean colorOutput = true;
    private boolean profile;

    public StartParameter() {
        String gradleUserHome = System.getProperty(GRADLE_USER_HOME_PROPERTY_KEY);
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = DEFAULT_GRADLE_USER_HOME.getAbsolutePath();
        }
        this.gradleUserHomeDir = GFileUtils.canonicalise(new File(gradleUserHome));
        this.setCurrentDir(null);
    }

    public StartParameter newInstance() {
        StartParameter startParameter = new StartParameter();
        startParameter.buildFile = this.buildFile;
        startParameter.taskNames = this.taskNames;
        startParameter.projectDependenciesBuildInstruction = this.projectDependenciesBuildInstruction;
        startParameter.currentDir = this.currentDir;
        startParameter.searchUpwards = this.searchUpwards;
        startParameter.projectProperties = this.projectProperties;
        startParameter.systemPropertiesArgs = this.systemPropertiesArgs;
        startParameter.gradleUserHomeDir = this.gradleUserHomeDir;
        startParameter.cacheUsage = this.cacheUsage;
        startParameter.buildScriptSource = this.buildScriptSource;
        startParameter.settingsScriptSource = this.settingsScriptSource;
        startParameter.initScripts = new ArrayList<File>(this.initScripts);
        startParameter.buildExecuter = this.buildExecuter;
        startParameter.defaultProjectSelector = this.defaultProjectSelector;
        startParameter.logLevel = this.logLevel;
        startParameter.colorOutput = this.colorOutput;
        startParameter.showStacktrace = this.showStacktrace;
        startParameter.dryRun = this.dryRun;
        startParameter.noOpt = this.noOpt;
        startParameter.profile = this.profile;
        return startParameter;
    }

    public StartParameter newBuild() {
        StartParameter startParameter = new StartParameter();
        startParameter.gradleUserHomeDir = this.gradleUserHomeDir;
        startParameter.cacheUsage = this.cacheUsage;
        startParameter.logLevel = this.logLevel;
        startParameter.colorOutput = this.colorOutput;
        startParameter.profile = this.profile;
        return startParameter;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(File buildFile) {
        if (buildFile == null) {
            this.buildFile = null;
            this.setCurrentDir(null);
        } else {
            this.buildFile = GFileUtils.canonicalise(buildFile);
            this.currentDir = this.buildFile.getParentFile();
            this.defaultProjectSelector = new BuildFileProjectSpec(this.buildFile);
        }
    }

    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    public ScriptSource getSettingsScriptSource() {
        return this.settingsScriptSource;
    }

    public void setSettingsScriptSource(ScriptSource settingsScriptSource) {
        this.settingsScriptSource = settingsScriptSource;
    }

    public StartParameter useEmbeddedBuildFile(String buildScriptText) {
        return this.setBuildScriptSource(new StringScriptSource("embedded build file", buildScriptText));
    }

    public StartParameter setBuildScriptSource(ScriptSource buildScript) {
        this.buildScriptSource = buildScript;
        this.settingsScriptSource = new StringScriptSource("empty settings file", "");
        this.searchUpwards = false;
        return this;
    }

    public BuildExecuter getBuildExecuter() {
        BuildExecuter executer = this.buildExecuter;
        if (executer == null) {
            executer = new DefaultBuildExecuter(this.taskNames, this.excludedTaskNames);
        }
        if (this.dryRun) {
            executer = new DryRunBuildExecuter(executer);
        }
        return executer;
    }

    public void setBuildExecuter(BuildExecuter buildExecuter) {
        this.buildExecuter = buildExecuter;
    }

    public List<String> getTaskNames() {
        return this.taskNames;
    }

    public void setTaskNames(Collection<String> taskNames) {
        this.taskNames = !GUtil.isTrue(taskNames) ? new ArrayList<String>() : new ArrayList<String>(taskNames);
        this.buildExecuter = null;
    }

    public Set<String> getExcludedTaskNames() {
        return this.excludedTaskNames;
    }

    public void setExcludedTaskNames(Collection<String> excludedTaskNames) {
        this.excludedTaskNames = !GUtil.isTrue(excludedTaskNames) ? new HashSet<String>() : new HashSet<String>(excludedTaskNames);
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(File currentDir) {
        this.currentDir = currentDir != null ? GFileUtils.canonicalise(currentDir) : GFileUtils.canonicalise(new File(System.getProperty("user.dir")));
        this.defaultProjectSelector = null;
    }

    public boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public void setSearchUpwards(boolean searchUpwards) {
        this.searchUpwards = searchUpwards;
    }

    public Map<String, String> getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(Map<String, String> projectProperties) {
        this.projectProperties = projectProperties;
    }

    public Map<String, String> getSystemPropertiesArgs() {
        return this.systemPropertiesArgs;
    }

    public void setSystemPropertiesArgs(Map<String, String> systemPropertiesArgs) {
        this.systemPropertiesArgs = systemPropertiesArgs;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public void setGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir == null ? DEFAULT_GRADLE_USER_HOME : GFileUtils.canonicalise(gradleUserHomeDir);
    }

    public ProjectDependenciesBuildInstruction getProjectDependenciesBuildInstruction() {
        return this.projectDependenciesBuildInstruction;
    }

    public void setProjectDependenciesBuildInstruction(ProjectDependenciesBuildInstruction projectDependenciesBuildInstruction) {
        this.projectDependenciesBuildInstruction = projectDependenciesBuildInstruction;
    }

    public CacheUsage getCacheUsage() {
        return this.cacheUsage;
    }

    public void setCacheUsage(CacheUsage cacheUsage) {
        this.cacheUsage = cacheUsage;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isNoOpt() {
        return this.noOpt;
    }

    public void setNoOpt(boolean noOpt) {
        this.noOpt = noOpt;
    }

    public void setSettingsFile(File settingsFile) {
        if (settingsFile == null) {
            this.settingsScriptSource = null;
        } else {
            File canonicalFile = GFileUtils.canonicalise(settingsFile);
            this.currentDir = canonicalFile.getParentFile();
            this.settingsScriptSource = new UriScriptSource("settings file", canonicalFile);
        }
    }

    public void addInitScript(File initScriptFile) {
        this.initScripts.add(initScriptFile);
    }

    public void setInitScripts(List<File> initScripts) {
        this.initScripts = initScripts;
    }

    public List<File> getInitScripts() {
        return Collections.unmodifiableList(this.initScripts);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public ShowStacktrace getShowStacktrace() {
        return this.showStacktrace;
    }

    public void setShowStacktrace(ShowStacktrace showStacktrace) {
        this.showStacktrace = showStacktrace;
    }

    public ProjectSpec getDefaultProjectSelector() {
        return this.defaultProjectSelector != null ? this.defaultProjectSelector : new DefaultProjectSpec(this.currentDir);
    }

    public void setDefaultProjectSelector(ProjectSpec defaultProjectSelector) {
        this.defaultProjectSelector = defaultProjectSelector;
    }

    public void setProjectDir(File projectDir) {
        if (projectDir == null) {
            this.setCurrentDir(null);
        } else {
            File canonicalFile;
            this.currentDir = canonicalFile = GFileUtils.canonicalise(projectDir);
            this.defaultProjectSelector = new ProjectDirectoryProjectSpec(canonicalFile);
        }
    }

    public boolean isColorOutput() {
        return this.colorOutput;
    }

    public void setColorOutput(boolean colorOutput) {
        this.colorOutput = colorOutput;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public String toString() {
        return "StartParameter{taskNames=" + this.taskNames + ", excludedTaskNames=" + this.excludedTaskNames + ", currentDir=" + this.currentDir + ", searchUpwards=" + this.searchUpwards + ", projectProperties=" + this.projectProperties + ", systemPropertiesArgs=" + this.systemPropertiesArgs + ", gradleUserHomeDir=" + this.gradleUserHomeDir + ", cacheUsage=" + (Object)((Object)this.cacheUsage) + ", buildScriptSource=" + this.buildScriptSource + ", settingsScriptSource=" + this.settingsScriptSource + ", buildExecuter=" + this.buildExecuter + ", defaultProjectSelector=" + this.defaultProjectSelector + ", logLevel=" + (Object)((Object)this.logLevel) + ", showStacktrace=" + (Object)((Object)this.showStacktrace) + ", buildFile=" + this.buildFile + ", initScripts=" + this.initScripts + ", dryRun=" + this.dryRun + ", noOpt=" + this.noOpt + ", profile=" + this.profile + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShowStacktrace {
        INTERNAL_EXCEPTIONS,
        ALWAYS,
        ALWAYS_FULL;

    }
}

