/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AsyncStoppable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLifecycle
implements AsyncStoppable {
    private final String displayName;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private State state = State.RUNNING;
    private Map<Thread, Integer> usages = new HashMap<Thread, Integer>();

    public ServiceLifecycle(String displayName) {
        this.displayName = displayName;
    }

    public void use(Runnable runnable) {
        this.use(Factories.toFactory(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T use(Factory<T> factory) {
        Object v1;
        T t;
        this.lock.lock();
        try {
            switch (this.state) {
                case STOPPING: {
                    throw new IllegalStateException(String.format("Cannot use %s as it is currently stopping.", this.displayName));
                }
                case STOPPED: {
                    throw new IllegalStateException(String.format("Cannot use %s as it has been stopped.", this.displayName));
                }
            }
            Integer depth = this.usages.get(Thread.currentThread());
            if (depth == null) {
                this.usages.put(Thread.currentThread(), 1);
            } else {
                this.usages.put(Thread.currentThread(), depth + 1);
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            t = factory.create();
            Object var5_4 = null;
            this.lock.lock();
        }
        catch (Throwable throwable) {
            Object v0;
            Object var5_5 = null;
            this.lock.lock();
            try {
                Integer depth = this.usages.remove(Thread.currentThread());
                if (depth > 1) {
                    this.usages.put(Thread.currentThread(), depth - 1);
                }
                if (this.usages.isEmpty()) {
                    this.condition.signalAll();
                    if (this.state == State.STOPPING) {
                        this.state = State.STOPPED;
                    }
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var8_11 = v0;
            this.lock.unlock();
            throw throwable;
        }
        try {
            Integer depth = this.usages.remove(Thread.currentThread());
            if (depth > 1) {
                this.usages.put(Thread.currentThread(), depth - 1);
            }
            if (this.usages.isEmpty()) {
                this.condition.signalAll();
                if (this.state == State.STOPPING) {
                    this.state = State.STOPPED;
                }
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var8_10 = v1;
        this.lock.unlock();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this.lock.lock();
        try {
            if (this.state == State.RUNNING) {
                this.state = this.usages.isEmpty() ? State.STOPPED : State.STOPPING;
            }
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            if (this.usages.containsKey(Thread.currentThread())) {
                throw new IllegalStateException(String.format("Cannot stop %s from a thread that is using it.", this.displayName));
            }
            if (this.state == State.RUNNING) {
                this.state = State.STOPPING;
            }
            while (!this.usages.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            if (this.state != State.STOPPED) {
                this.state = State.STOPPED;
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

