/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import com.google.common.base.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tuple<L, R> {
    public final L left;
    public final R right;

    private Tuple(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public L left() {
        return this.left;
    }

    public R right() {
        return this.right;
    }

    public static <L, R> Tuple<L, R> of(L left, R right) {
        return new Tuple<L, R>(left, right);
    }

    public <T> Tuple<T, Tuple<L, R>> pushLeft(T t) {
        return Tuple.of(t, this);
    }

    public <T> Tuple<Tuple<L, R>, T> pushRight(T t) {
        return Tuple.of(this, t);
    }

    public <T> Tuple<Tuple<T, L>, R> nestLeft(T t) {
        return Tuple.of(Tuple.of(t, this.left), this.right);
    }

    public <T> Tuple<L, Tuple<T, R>> nestRight(T t) {
        return Tuple.of(this.left, Tuple.of(t, this.right));
    }

    public <T> Tuple<T, R> mapLeft(Function<? super L, ? extends T> function) throws Exception {
        return Tuple.of(function.apply(this.left), this.right);
    }

    public <T> Tuple<L, T> mapRight(Function<? super R, ? extends T> function) throws Exception {
        return Tuple.of(this.left, function.apply(this.right));
    }

    public <T> T map(Function<? super Tuple<L, R>, ? extends T> function) throws Exception {
        return (T)function.apply((Object)this);
    }

    public static <L, T extends Tuple<L, ?>> Function<T, L> unpackLeft() {
        return new Function<T, L>(){

            public L apply(T tuple) {
                return ((Tuple)tuple).left;
            }
        };
    }

    public static <R, T extends Tuple<?, R>> Function<T, R> unpackRight() {
        return new Function<T, R>(){

            public R apply(T tuple) {
                return ((Tuple)tuple).right;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return !(this.left == null ? tuple.left != null : !this.left.equals(tuple.left)) && !(this.right == null ? tuple.right != null : !this.right.equals(tuple.right));
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Tuple[" + this.left + "," + this.right + ']';
    }
}

