/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Factory;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.service.AbstractServiceRegistry;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceRegistry
extends AbstractServiceRegistry {
    private final List<Provider> providers = new LinkedList<Provider>();
    private final OwnServices ownServices;
    private final List<Provider> registeredProviders;
    private final ServiceRegistry parent;
    private boolean closed;

    public DefaultServiceRegistry() {
        this(null);
    }

    public DefaultServiceRegistry(ServiceRegistry parent) {
        this.parent = parent;
        this.ownServices = new OwnServices();
        this.providers.add(this.ownServices);
        if (parent != null) {
            this.providers.add(new ParentServices());
        }
        this.registeredProviders = this.providers.subList(1, 1);
        this.findProviderMethods();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private void findProviderMethods() {
        HashSet<String> factoryMethods = new HashSet<String>();
        HashSet<String> decoratorMethods = new HashSet<String>();
        for (Class<?> type = this.getClass(); type != Object.class; type = type.getSuperclass()) {
            this.findFactoryMethods(type, factoryMethods, this.ownServices);
            this.findDecoratorMethods(type, decoratorMethods, this.ownServices);
        }
    }

    private void findFactoryMethods(Class<?> type, Set<String> factoryMethods, OwnServices ownServices) {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.class || !factoryMethods.add(method.getName())) continue;
            ownServices.add(new FactoryMethodService(method));
        }
    }

    private void findDecoratorMethods(Class<?> type, Set<String> decoratorMethods, OwnServices ownServices) {
        for (Method method : type.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length != 1 || method.getReturnType() == Void.class || !method.getParameterTypes()[0].equals(method.getReturnType())) continue;
            if (this.parent == null) {
                throw new ServiceLookupException("Cannot use decorator methods when no parent registry is provided.");
            }
            if (!decoratorMethods.add(method.getName())) continue;
            ownServices.add(new DecoratorMethodService(method));
        }
    }

    public void add(ServiceRegistry nested) {
        this.registeredProviders.add(new NestedServices(nested));
    }

    public <T> void add(Class<T> serviceType, T serviceInstance) {
        this.ownServices.add(new FixedInstanceService<T>(serviceType, serviceInstance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            CompositeStoppable.stoppable(this.providers).stop();
        }
        finally {
            this.closed = true;
            this.providers.clear();
        }
    }

    @Override
    public <T> T doGet(Class<T> serviceType) throws IllegalArgumentException {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", serviceType.getSimpleName(), this));
        }
        for (Provider service : this.providers) {
            T t = service.getService(serviceType);
            if (t == null) continue;
            return t;
        }
        throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", serviceType.getSimpleName(), this));
    }

    @Override
    public <T> Factory<T> getFactory(Class<T> type) {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot locate factory for objects of type %s, as %s has been closed.", type.getSimpleName(), this));
        }
        for (Provider service : this.providers) {
            Factory<T> factory = service.getFactory(type);
            if (factory == null) continue;
            return factory;
        }
        throw new UnknownServiceException(type, String.format("No factory for objects of type %s available in %s.", type.getSimpleName(), this));
    }

    private static Object invoke(Method method, Object target, Object ... args) {
        try {
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentServices
    implements Provider {
        private ParentServices() {
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> type) {
            try {
                Factory<T> factory = DefaultServiceRegistry.this.parent.getFactory(type);
                assert (factory != null) : String.format("parent returned null for factory type '%s'", type.getName());
                return factory;
            }
            catch (UnknownServiceException e) {
                if (e.getType().equals(type)) {
                    return null;
                }
                throw e;
            }
        }

        @Override
        public <T> T getService(Class<T> serviceType) {
            try {
                T service = DefaultServiceRegistry.this.parent.get(serviceType);
                assert (service != null) : String.format("parent returned null for service type '%s'", serviceType.getName());
                return service;
            }
            catch (UnknownServiceException e) {
                if (e.getType().equals(serviceType)) {
                    return null;
                }
                throw e;
            }
        }

        @Override
        public void stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NestedServices
    extends ManagedObjectProvider<ServiceRegistry> {
        private final ServiceRegistry nested;

        public NestedServices(ServiceRegistry nested) {
            this.nested = nested;
            this.getInstance();
        }

        @Override
        protected ServiceRegistry create() {
            return this.nested;
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> type) {
            try {
                Factory<T> factory = ((ServiceRegistry)this.getInstance()).getFactory(type);
                assert (factory != null);
                assert (factory != null) : String.format("nested registry returned null for factory type '%s'", type.getName());
                return factory;
            }
            catch (UnknownServiceException e) {
                if (e.getType().equals(type)) {
                    return null;
                }
                throw e;
            }
        }

        @Override
        public <T> T getService(Class<T> serviceType) {
            try {
                T service = ((ServiceRegistry)this.getInstance()).get(serviceType);
                assert (service != null) : String.format("nested registry returned null for service type '%s'", serviceType.getName());
                return service;
            }
            catch (UnknownServiceException e) {
                if (e.getType().equals(serviceType)) {
                    return null;
                }
                throw e;
            }
        }
    }

    private class DecoratorMethodService
    extends SingletonService {
        private final Method method;

        public DecoratorMethodService(Method method) {
            super(method.getGenericReturnType());
            this.method = method;
        }

        protected Object create() {
            Object value;
            if (Factory.class.isAssignableFrom(this.method.getParameterTypes()[0])) {
                Class type;
                ParameterizedType fatoryType = (ParameterizedType)this.method.getGenericParameterTypes()[0];
                Type typeArg = fatoryType.getActualTypeArguments()[0];
                if (typeArg instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)typeArg;
                    type = (Class)wildcardType.getUpperBounds()[0];
                } else {
                    type = (Class)typeArg;
                }
                value = DefaultServiceRegistry.this.parent.getFactory(type);
            } else {
                value = DefaultServiceRegistry.this.parent.get(this.method.getParameterTypes()[0]);
            }
            return DefaultServiceRegistry.invoke(this.method, DefaultServiceRegistry.this, new Object[]{value});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedInstanceService<T>
    extends SingletonService {
        private final T serviceInstance;

        public FixedInstanceService(Class<T> serviceType, T serviceInstance) {
            super(serviceType);
            this.serviceInstance = serviceInstance;
            this.getService(serviceType);
        }

        @Override
        protected Object create() {
            return this.serviceInstance;
        }
    }

    private class FactoryMethodService
    extends SingletonService {
        private final Method method;

        public FactoryMethodService(Method method) {
            super(method.getGenericReturnType());
            this.method = method;
        }

        protected Object create() {
            return DefaultServiceRegistry.invoke(this.method, DefaultServiceRegistry.this, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SingletonService
    extends ManagedObjectProvider<Object> {
        final Type serviceType;
        final Class serviceClass;

        SingletonService(Type serviceType) {
            this.serviceType = serviceType;
            this.serviceClass = this.toClass(serviceType);
        }

        public String toString() {
            return String.format("Service %s", this.serviceType);
        }

        @Override
        public <T> T getService(Class<T> serviceType) {
            if (!serviceType.isAssignableFrom(this.serviceClass)) {
                return null;
            }
            return serviceType.cast(this.getInstance());
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> elementType) {
            if (!Factory.class.isAssignableFrom(this.serviceClass)) {
                return null;
            }
            return this.getFactory(this.serviceType, elementType);
        }

        private <T> Factory<T> getFactory(Type type, Class<T> elementType) {
            Type actualType;
            ParameterizedType parameterizedType;
            Class c = this.toClass(type);
            if (!Factory.class.isAssignableFrom(c)) {
                return null;
            }
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Factory.class) && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class && elementType.isAssignableFrom((Class)actualType)) {
                Factory f = this.getService(Factory.class);
                return f;
            }
            for (Type interfaceType : c.getGenericInterfaces()) {
                Factory<T> f = this.getFactory(interfaceType, elementType);
                if (f == null) continue;
                return f;
            }
            return null;
        }

        private Class toClass(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ManagedObjectProvider<T>
    implements Provider {
        private T instance;

        private ManagedObjectProvider() {
        }

        public T getInstance() {
            if (this.instance == null) {
                this.instance = this.create();
                assert (this.instance != null) : String.format("create() of %s returned null", this.toString());
            }
            return this.instance;
        }

        protected abstract T create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                CompositeStoppable.stoppable(this.instance).stop();
            }
            finally {
                this.instance = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnServices
    implements Provider {
        private final List<Provider> providers = new ArrayList<Provider>();

        private OwnServices() {
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> type) {
            Factory<T> match = null;
            for (Provider provider : this.providers) {
                Factory<T> factory = provider.getFactory(type);
                if (factory == null) continue;
                if (match != null) {
                    throw new ServiceLookupException(String.format("Multiple factories for objects of type %s available in %s.", type.getSimpleName(), DefaultServiceRegistry.this.toString()));
                }
                match = factory;
            }
            return match;
        }

        @Override
        public <T> T getService(Class<T> serviceType) {
            T match = null;
            for (Provider provider : this.providers) {
                T service = provider.getService(serviceType);
                if (service == null) continue;
                if (match != null) {
                    throw new ServiceLookupException(String.format("Multiple services of type %s available in %s.", serviceType.getSimpleName(), DefaultServiceRegistry.this.toString()));
                }
                match = service;
            }
            return match;
        }

        @Override
        public void stop() {
            CompositeStoppable.stoppable(this.providers).stop();
        }

        public void add(Provider provider) {
            this.providers.add(provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Provider
    extends Stoppable {
        public <T> T getService(Class<T> var1);

        public <T> Factory<T> getFactory(Class<T> var1);
    }
}

