/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.gradle.internal.Factory;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    @Override
    public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
        ParameterizedType parameterizedType;
        if (serviceType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)serviceType).getRawType().equals(Factory.class)) {
            Type typeArg = parameterizedType.getActualTypeArguments()[0];
            if (typeArg instanceof Class) {
                return this.getFactory((Class)typeArg);
            }
            if (typeArg instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)typeArg;
                if (wildcardType.getLowerBounds().length == 1 && wildcardType.getUpperBounds().length == 1 && wildcardType.getLowerBounds()[0] instanceof Class && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                    return this.getFactory((Class)wildcardType.getLowerBounds()[0]);
                }
                if (wildcardType.getLowerBounds().length == 0 && wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] instanceof Class) {
                    return this.getFactory((Class)wildcardType.getUpperBounds()[0]);
                }
            }
        }
        if (serviceType instanceof Class) {
            return this.get((Class)serviceType);
        }
        throw new UnsupportedOperationException(String.format("Cannot locate service of type %s yet.", serviceType));
    }

    @Override
    public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
        if (serviceType.equals(Factory.class)) {
            throw new IllegalArgumentException("Cannot locate service of raw type Factory. Use getFactory() or get(Type) instead.");
        }
        if (serviceType.isArray()) {
            throw new IllegalArgumentException(String.format("Cannot locate service of array type %s[].", serviceType.getComponentType().getSimpleName()));
        }
        if (serviceType.isAnnotation()) {
            throw new IllegalArgumentException(String.format("Cannot locate service of annotation type @%s.", serviceType.getSimpleName()));
        }
        return this.doGet(serviceType);
    }

    protected abstract <T> T doGet(Class<T> var1);

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.getFactory(type).create();
    }
}

