/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.util.CollectionUtils;
import org.gradle.util.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReflectionUtil {
    public static Object readProperty(Object target, String property) {
        try {
            Method getterMethod;
            try {
                getterMethod = target.getClass().getMethod(JavaReflectionUtil.toMethodName("get", property), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getterMethod = target.getClass().getMethod(JavaReflectionUtil.toMethodName("is", property), new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    throw e;
                }
            }
            return getterMethod.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static void writeProperty(Object target, String property, Object value) {
        try {
            String setterName = JavaReflectionUtil.toMethodName("set", property);
            for (Method method : target.getClass().getMethods()) {
                if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1) continue;
                method.invoke(target, value);
                return;
            }
            throw new NoSuchMethodException(String.format("could not find setter method '%s'", setterName));
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private static String toMethodName(String prefix, String propertyName) {
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static Class<?> getWrapperTypeForPrimitiveType(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(String.format("Don't know how wrapper type for primitive type %s.", type));
    }

    public static <T, R> JavaMethod<T, R> method(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        return new JavaMethod<T, R>(target, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> method(Class<T> target, Class<R> returnType, Method method) {
        return new JavaMethod<T, R>(target, returnType, method);
    }

    public static void searchMethods(Class<?> target, final Transformer<Boolean, Method> stopIndicator) {
        Spec<Method> stopIndicatorAsSpec = new Spec<Method>(){

            @Override
            public boolean isSatisfiedBy(Method element) {
                return (Boolean)stopIndicator.transform(element);
            }
        };
        JavaReflectionUtil.findAllMethodsInternal(target, stopIndicatorAsSpec, new MultiMap<String, Method>(), new ArrayList<Method>(1), true);
    }

    public static List<Method> findAllMethods(Class<?> target, Spec<Method> predicate) {
        return JavaReflectionUtil.findAllMethodsInternal(target, predicate, new MultiMap<String, Method>(), new LinkedList<Method>(), false);
    }

    public static Method findMethod(Class<?> target, Spec<Method> predicate) {
        List<Method> methods = JavaReflectionUtil.findAllMethodsInternal(target, predicate, new MultiMap<String, Method>(), new ArrayList<Method>(1), true);
        return methods.isEmpty() ? null : methods.get(0);
    }

    private static List<Method> findAllMethodsInternal(Class<?> target, Spec<Method> predicate, MultiMap<String, Method> seen, List<Method> collector, boolean stopAtFirst) {
        for (final Method method : target.getDeclaredMethods()) {
            Object seenWithName = seen.get(method.getName());
            Method override = CollectionUtils.findFirst(seenWithName, new Spec<Method>(){

                @Override
                public boolean isSatisfiedBy(Method potentionOverride) {
                    return potentionOverride.getName().equals(method.getName()) && Arrays.equals(potentionOverride.getParameterTypes(), method.getParameterTypes());
                }
            });
            if (override != null) continue;
            seenWithName.add(method);
            if (!predicate.isSatisfiedBy(method)) continue;
            collector.add(method);
            if (!stopAtFirst) continue;
            return collector;
        }
        Class<?> parent = target.getSuperclass();
        if (parent != null) {
            return JavaReflectionUtil.findAllMethodsInternal(parent, predicate, seen, collector, stopAtFirst);
        }
        return collector;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType) {
        return JavaReflectionUtil.getAnnotation(type, annotationType, true);
    }

    private static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType, boolean checkType) {
        A annotation;
        if (checkType && (annotation = type.getAnnotation(annotationType)) != null) {
            return annotation;
        }
        if (annotationType.getAnnotation(Inherited.class) != null) {
            for (Class<?> anInterface : type.getInterfaces()) {
                annotation = JavaReflectionUtil.getAnnotation(anInterface, annotationType, true);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if (type.isInterface() || type.equals(Object.class)) {
            return null;
        }
        return JavaReflectionUtil.getAnnotation(type.getSuperclass(), annotationType, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiMap<K, V>
    extends HashMap<K, List<V>> {
        private MultiMap() {
        }

        @Override
        public List<V> get(Object key) {
            if (!this.containsKey(key)) {
                Object keyCast = key;
                this.put(keyCast, new LinkedList());
            }
            return (List)super.get(key);
        }
    }
}

