/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutorFactory
implements ExecutorFactory,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutorFactory.class);
    private final Set<StoppableExecutorImpl> executors = new CopyOnWriteArraySet<StoppableExecutorImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.executors).stop();
        }
        finally {
            this.executors.clear();
        }
    }

    public StoppableExecutor create(String displayName) {
        StoppableExecutorImpl executor = new StoppableExecutorImpl(this.createExecutor(displayName));
        this.executors.add(executor);
        return executor;
    }

    protected ExecutorService createExecutor(String displayName) {
        return Executors.newCachedThreadPool(new ThreadFactoryImpl(displayName));
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private final AtomicLong counter = new AtomicLong();
        private final String displayName;

        public ThreadFactoryImpl(String displayName) {
            this.displayName = displayName;
        }

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            long count = this.counter.incrementAndGet();
            if (count == 1L) {
                thread.setName(this.displayName);
            } else {
                thread.setName(String.format("%s Thread %s", this.displayName, count));
            }
            return thread;
        }
    }

    private class StoppableExecutorImpl
    implements StoppableExecutor {
        private final ExecutorService executor;
        private final ThreadLocal<Runnable> executing = new ThreadLocal();
        private final AtomicReference<Throwable> failure = new AtomicReference();

        public StoppableExecutorImpl(ExecutorService executor) {
            this.executor = executor;
        }

        public void execute(final Runnable command) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    StoppableExecutorImpl.this.executing.set(command);
                    try {
                        command.run();
                    }
                    catch (Throwable throwable) {
                        if (!StoppableExecutorImpl.this.failure.compareAndSet(null, throwable)) {
                            LOGGER.error(String.format("Failed to execute %s.", command), throwable);
                        }
                    }
                    finally {
                        StoppableExecutorImpl.this.executing.set(null);
                    }
                }
            });
        }

        public void requestStop() {
            this.executor.shutdown();
        }

        public void stop() {
            this.stop(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            this.requestStop();
            if (this.executing.get() != null) {
                throw new IllegalStateException("Cannot stop this executor from an executor thread.");
            }
            try {
                try {
                    if (!this.executor.awaitTermination(timeoutValue, timeoutUnits)) {
                        this.executor.shutdownNow();
                        throw new IllegalStateException("Timeout waiting for concurrent jobs to complete.");
                    }
                }
                catch (InterruptedException e) {
                    throw new UncheckedException(e);
                }
                if (this.failure.get() != null) {
                    throw UncheckedException.throwAsUncheckedException(this.failure.get());
                }
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }
}

