/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    VERSION_1_1(false),
    VERSION_1_2(false),
    VERSION_1_3(false),
    VERSION_1_4(false),
    VERSION_1_5(true),
    VERSION_1_6(true),
    VERSION_1_7(true),
    VERSION_1_8(true);

    private final boolean hasMajorVersion;

    private JavaVersion(boolean hasMajorVersion) {
        this.hasMajorVersion = hasMajorVersion;
    }

    public static JavaVersion toVersion(Object value) throws IllegalArgumentException {
        int versionIdx;
        int index;
        if (value == null) {
            return null;
        }
        if (value instanceof JavaVersion) {
            return (JavaVersion)((Object)value);
        }
        String name = value.toString();
        if (name.matches("\\d") && (index = Integer.parseInt(name) - 1) < JavaVersion.values().length && JavaVersion.values()[index].hasMajorVersion) {
            return JavaVersion.values()[index];
        }
        Matcher matcher = Pattern.compile("1\\.(\\d)(\\D.*)?").matcher(name);
        if (matcher.matches() && (versionIdx = Integer.parseInt(matcher.group(1)) - 1) >= 0 && versionIdx < JavaVersion.values().length) {
            return JavaVersion.values()[versionIdx];
        }
        throw new IllegalArgumentException(String.format("Could not determine java version from '%s'.", name));
    }

    public static JavaVersion current() {
        return JavaVersion.toVersion(SystemProperties.getJavaVersion());
    }

    public boolean isJava5() {
        return this == VERSION_1_5;
    }

    public boolean isJava6() {
        return this == VERSION_1_6;
    }

    public boolean isJava7() {
        return this == VERSION_1_7;
    }

    private boolean isJava8() {
        return this == VERSION_1_8;
    }

    public boolean isJava5Compatible() {
        return this.isJava5() || this.isJava6Compatible();
    }

    public boolean isJava6Compatible() {
        return this.isJava6() || this.isJava7Compatible();
    }

    public boolean isJava7Compatible() {
        return this.isJava7() || this.isJava8Compatible();
    }

    public boolean isJava8Compatible() {
        return this.isJava8();
    }

    public String toString() {
        return this.getName();
    }

    private String getName() {
        return this.name().substring("VERSION_".length()).replace('_', '.');
    }
}

