/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.Transformers;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Actions {
    public static <T> Action<T> doNothing() {
        return new NullAction();
    }

    public static <T> Action<T> composite(Action<? super T> ... actions) {
        ArrayList actionsCopy = new ArrayList(actions.length);
        Collections.addAll(actionsCopy, actions);
        return new CompositeAction(actionsCopy);
    }

    public static <T, I> Action<I> transformBefore(Action<? super T> action, Transformer<? extends T, ? super I> transformer) {
        return new TransformingActionAdapter(transformer, action);
    }

    public static <T, I> Action<I> castBefore(Class<T> actionType, Action<? super T> action) {
        return Actions.transformBefore(action, Transformers.cast(actionType));
    }

    public static <T> Action<T> toAction(Runnable runnable) {
        if (runnable == null) {
            return Actions.doNothing();
        }
        return new RunnableActionAdapter(runnable);
    }

    public static <T> Action<T> filter(Action<? super T> action, Spec<? super T> filter) {
        return new FilteredAction<T>(action, filter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredAction<T>
    implements Action<T> {
        private final Spec<? super T> filter;
        private final Action<? super T> action;

        public FilteredAction(Action<? super T> action, Spec<? super T> filter) {
            this.filter = filter;
            this.action = action;
        }

        @Override
        public void execute(T t) {
            if (this.filter.isSatisfiedBy(t)) {
                this.action.execute(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunnableActionAdapter<T>
    implements Action<T> {
        private final Runnable runnable;

        private RunnableActionAdapter(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void execute(T t) {
            this.runnable.run();
        }

        public String toString() {
            return String.format("RunnableActionAdapter{runnable=%s}", this.runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformingActionAdapter<T, I>
    implements Action<I> {
        private final Transformer<? extends T, ? super I> transformer;
        private final Action<? super T> action;

        private TransformingActionAdapter(Transformer<? extends T, ? super I> transformer, Action<? super T> action) {
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public void execute(I thing) {
            T transformed = this.transformer.transform(thing);
            this.action.execute(transformed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeAction<T>
    implements Action<T> {
        private final Iterable<Action<? super T>> actions;

        private CompositeAction(Iterable<Action<? super T>> actions) {
            this.actions = actions;
        }

        @Override
        public void execute(T item) {
            for (Action<T> action : this.actions) {
                action.execute(item);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullAction<T>
    implements Action<T>,
    Serializable {
        private NullAction() {
        }

        @Override
        public void execute(T t) {
        }
    }
}

