/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Type;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Synchronizer;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedServiceRegistry
implements ServiceRegistry {
    private final Synchronizer synchronizer = new Synchronizer();
    private final ServiceRegistry delegate;

    public SynchronizedServiceRegistry(ServiceRegistry delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> T get(final Class<T> serviceType) throws UnknownServiceException {
        return this.synchronizer.synchronize(new Factory<T>(){

            @Override
            public T create() {
                return SynchronizedServiceRegistry.this.delegate.get(serviceType);
            }
        });
    }

    @Override
    public Object get(final Type serviceType) throws UnknownServiceException, ServiceLookupException {
        return this.synchronizer.synchronize(new Factory<Object>(){

            @Override
            public Object create() {
                return SynchronizedServiceRegistry.this.delegate.get(serviceType);
            }
        });
    }

    @Override
    public <T> Factory<T> getFactory(final Class<T> type) throws UnknownServiceException {
        return (Factory)this.synchronizer.synchronize(new Factory<Factory<T>>(){

            @Override
            public Factory<T> create() {
                return new SynchronizedFactory(SynchronizedServiceRegistry.this.delegate.getFactory(type));
            }
        });
    }

    @Override
    public <T> T newInstance(final Class<T> type) throws UnknownServiceException {
        return this.synchronizer.synchronize(new Factory<T>(){

            @Override
            public T create() {
                return SynchronizedServiceRegistry.this.delegate.newInstance(type);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SynchronizedFactory<T>
    implements Factory<T> {
        private final Factory<T> delegateFactory;

        public SynchronizedFactory(Factory<T> delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        @Override
        public T create() {
            return SynchronizedServiceRegistry.this.synchronizer.synchronize(this.delegateFactory);
        }
    }
}

