/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.os;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperatingSystem {
    private static final Windows WINDOWS = new Windows();
    private static final MacOs MAC_OS = new MacOs();
    private static final Solaris SOLARIS = new Solaris();
    private static final Linux LINUX = new Linux();
    private static final Unix UNIX = new Unix();

    public static OperatingSystem current() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("mac os x") || osName.contains("darwin")) {
            return MAC_OS;
        }
        if (osName.contains("sunos")) {
            return SOLARIS;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        return UNIX;
    }

    public String toString() {
        return String.format("%s %s %s", this.getName(), this.getVersion(), System.getProperty("os.arch"));
    }

    public String getName() {
        return System.getProperty("os.name");
    }

    public String getVersion() {
        return System.getProperty("os.version");
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isUnix() {
        return false;
    }

    public boolean isMacOsX() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    public abstract String getNativePrefix();

    public abstract String getScriptName(String var1);

    public abstract String getExecutableName(String var1);

    public abstract String getSharedLibraryName(String var1);

    public File findInPath(String name) {
        String exeName = this.getExecutableName(name);
        if (exeName.contains(File.separator)) {
            File candidate = new File(exeName);
            if (candidate.isFile()) {
                return candidate;
            }
            return null;
        }
        for (File dir : this.getPath()) {
            File candidate = new File(dir, exeName);
            if (!candidate.isFile()) continue;
            return candidate;
        }
        return null;
    }

    public List<File> findAllInPath(String name) {
        LinkedList<File> all = new LinkedList<File>();
        for (File dir : this.getPath()) {
            File candidate = new File(dir, name);
            if (!candidate.isFile()) continue;
            all.add(candidate);
        }
        return all;
    }

    List<File> getPath() {
        String path = System.getenv("PATH");
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<File> entries = new ArrayList<File>();
        for (String entry : path.split(Pattern.quote(File.pathSeparator))) {
            entries.add(new File(entry));
        }
        return entries;
    }

    static class Solaris
    extends Unix {
        Solaris() {
        }

        protected String getOsPrefix() {
            return "sunos";
        }

        protected String getArch() {
            String arch = System.getProperty("os.arch");
            if (arch.equals("i386") || arch.equals("x86")) {
                return "x86";
            }
            return super.getArch();
        }
    }

    static class Linux
    extends Unix {
        Linux() {
        }

        public boolean isLinux() {
            return true;
        }
    }

    static class MacOs
    extends Unix {
        MacOs() {
        }

        public boolean isMacOsX() {
            return true;
        }

        protected String getSharedLibSuffix() {
            return ".dylib";
        }

        public String getNativePrefix() {
            return "darwin";
        }
    }

    static class Unix
    extends OperatingSystem {
        Unix() {
        }

        public String getScriptName(String scriptPath) {
            return scriptPath;
        }

        public String getExecutableName(String executablePath) {
            return executablePath;
        }

        public String getSharedLibraryName(String libraryName) {
            String suffix = this.getSharedLibSuffix();
            if (libraryName.endsWith(suffix)) {
                return libraryName;
            }
            int pos = libraryName.lastIndexOf(47);
            if (pos >= 0) {
                return libraryName.substring(0, pos + 1) + "lib" + libraryName.substring(pos + 1) + suffix;
            }
            return "lib" + libraryName + suffix;
        }

        protected String getSharedLibSuffix() {
            return ".so";
        }

        public boolean isUnix() {
            return true;
        }

        public String getNativePrefix() {
            String arch = this.getArch();
            String osPrefix = this.getOsPrefix();
            osPrefix = osPrefix + "-" + arch;
            return osPrefix;
        }

        protected String getArch() {
            String arch = System.getProperty("os.arch");
            if ("x86".equals(arch)) {
                arch = "i386";
            }
            if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            if ("powerpc".equals(arch)) {
                arch = "ppc";
            }
            return arch;
        }

        protected String getOsPrefix() {
            String osPrefix = this.getName().toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            return osPrefix;
        }
    }

    static class Windows
    extends OperatingSystem {
        Windows() {
        }

        public boolean isWindows() {
            return true;
        }

        public String getScriptName(String scriptPath) {
            if (scriptPath.toLowerCase().endsWith(".bat")) {
                return scriptPath;
            }
            return scriptPath + ".bat";
        }

        public String getExecutableName(String executablePath) {
            return this.withSuffix(executablePath, ".exe");
        }

        public String getSharedLibraryName(String libraryPath) {
            return this.withSuffix(libraryPath, ".dll");
        }

        public String getNativePrefix() {
            String arch = System.getProperty("os.arch");
            if ("i386".equals(arch)) {
                arch = "x86";
            }
            return "win32-" + arch;
        }

        private String withSuffix(String executablePath, String extension) {
            if (executablePath.toLowerCase().endsWith(extension)) {
                return executablePath;
            }
            return executablePath + extension;
        }
    }
}

