/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.internal.CompositeStoppable;
import org.gradle.internal.Factory;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.UnknownServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceRegistry
implements ServiceRegistry {
    private final List<Provider> providers = new LinkedList<Provider>();
    private final OwnServices ownServices;
    private final List<Provider> registeredProviders;
    private final ServiceRegistry parent;
    private boolean closed;

    public DefaultServiceRegistry() {
        this(null);
    }

    public DefaultServiceRegistry(ServiceRegistry serviceRegistry) {
        this.parent = serviceRegistry;
        this.ownServices = new OwnServices();
        this.providers.add(this.ownServices);
        if (serviceRegistry != null) {
            this.providers.add(new ParentServices());
        }
        this.registeredProviders = this.providers.subList(1, 1);
        this.findProviderMethods();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private void findProviderMethods() {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.findFactoryMethods(clazz, hashSet, this.ownServices);
            this.findDecoratorMethods(clazz, hashSet2, this.ownServices);
        }
    }

    private void findFactoryMethods(Class<?> clazz, Set<String> set, OwnServices ownServices) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.class || !set.add(method.getName())) continue;
            ownServices.add(new FactoryMethodService(method));
        }
    }

    private void findDecoratorMethods(Class<?> clazz, Set<String> set, OwnServices ownServices) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length != 1 || method.getReturnType() == Void.class || !method.getParameterTypes()[0].equals(method.getReturnType())) continue;
            if (this.parent == null) {
                throw new IllegalArgumentException("Cannot use decorator methods when no parent registry is provided.");
            }
            if (!set.add(method.getName())) continue;
            ownServices.add(new DecoratorMethodService(method));
        }
    }

    public void add(ServiceRegistry serviceRegistry) {
        this.registeredProviders.add(new NestedServices(serviceRegistry));
    }

    public <T> void add(Class<T> clazz, T t) {
        this.ownServices.add(new FixedInstanceService<T>(clazz, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            new CompositeStoppable(this.providers).stop();
        }
        finally {
            this.closed = true;
            this.providers.clear();
        }
    }

    @Override
    public <T> T get(Class<T> clazz) throws IllegalArgumentException {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot locate service of type %s, as %s has been closed.", clazz.getSimpleName(), this));
        }
        for (Provider provider : this.providers) {
            T t = provider.getService(clazz);
            if (t == null) continue;
            return t;
        }
        throw new UnknownServiceException(clazz, String.format("No service of type %s available in %s.", clazz.getSimpleName(), this));
    }

    @Override
    public <T> Factory<T> getFactory(Class<T> clazz) {
        if (this.closed) {
            throw new IllegalStateException(String.format("Cannot locate factory for objects of type %s, as %s has been closed.", clazz.getSimpleName(), this));
        }
        for (Provider provider : this.providers) {
            Factory<T> factory = provider.getFactory(clazz);
            if (factory == null) continue;
            return factory;
        }
        throw new UnknownServiceException(clazz, String.format("No factory for objects of type %s available in %s.", clazz.getSimpleName(), this));
    }

    @Override
    public <T> T newInstance(Class<T> clazz) {
        return this.getFactory(clazz).create();
    }

    private static Object invoke(Method method, Object object, Object ... objectArray) {
        try {
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw UncheckedException.throwAsUncheckedException(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            throw UncheckedException.throwAsUncheckedException(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentServices
    implements Provider {
        private ParentServices() {
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> clazz) {
            try {
                Factory<T> factory = DefaultServiceRegistry.this.parent.getFactory(clazz);
                assert (factory != null) : String.format("parent returned null for factory type '%s'", clazz.getName());
                return factory;
            }
            catch (UnknownServiceException unknownServiceException) {
                if (unknownServiceException.getType().equals(clazz)) {
                    return null;
                }
                throw unknownServiceException;
            }
        }

        @Override
        public <T> T getService(Class<T> clazz) {
            try {
                T t = DefaultServiceRegistry.this.parent.get(clazz);
                assert (t != null) : String.format("parent returned null for service type '%s'", clazz.getName());
                return t;
            }
            catch (UnknownServiceException unknownServiceException) {
                if (unknownServiceException.getType().equals(clazz)) {
                    return null;
                }
                throw unknownServiceException;
            }
        }

        @Override
        public void stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NestedServices
    extends ManagedObjectProvider<ServiceRegistry> {
        private final ServiceRegistry nested;

        public NestedServices(ServiceRegistry serviceRegistry) {
            this.nested = serviceRegistry;
            this.getInstance();
        }

        @Override
        protected ServiceRegistry create() {
            return this.nested;
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> clazz) {
            try {
                Factory<T> factory = ((ServiceRegistry)this.getInstance()).getFactory(clazz);
                assert (factory != null);
                assert (factory != null) : String.format("nested registry returned null for factory type '%s'", clazz.getName());
                return factory;
            }
            catch (UnknownServiceException unknownServiceException) {
                if (unknownServiceException.getType().equals(clazz)) {
                    return null;
                }
                throw unknownServiceException;
            }
        }

        @Override
        public <T> T getService(Class<T> clazz) {
            try {
                T t = ((ServiceRegistry)this.getInstance()).get(clazz);
                assert (t != null) : String.format("nested registry returned null for service type '%s'", clazz.getName());
                return t;
            }
            catch (UnknownServiceException unknownServiceException) {
                if (unknownServiceException.getType().equals(clazz)) {
                    return null;
                }
                throw unknownServiceException;
            }
        }
    }

    private class DecoratorMethodService
    extends SingletonService {
        private final Method method;

        public DecoratorMethodService(Method method) {
            super(method.getGenericReturnType());
            this.method = method;
        }

        protected Object create() {
            Object object;
            if (Factory.class.isAssignableFrom(this.method.getParameterTypes()[0])) {
                Class clazz;
                ParameterizedType parameterizedType = (ParameterizedType)this.method.getGenericParameterTypes()[0];
                Type type = parameterizedType.getActualTypeArguments()[0];
                if (type instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)type;
                    clazz = (Class)wildcardType.getUpperBounds()[0];
                } else {
                    clazz = (Class)type;
                }
                object = DefaultServiceRegistry.this.parent.getFactory(clazz);
            } else {
                object = DefaultServiceRegistry.this.parent.get(this.method.getParameterTypes()[0]);
            }
            return DefaultServiceRegistry.invoke(this.method, DefaultServiceRegistry.this, new Object[]{object});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedInstanceService<T>
    extends SingletonService {
        private final T serviceInstance;

        public FixedInstanceService(Class<T> clazz, T t) {
            super(clazz);
            this.serviceInstance = t;
            this.getService(clazz);
        }

        @Override
        protected Object create() {
            return this.serviceInstance;
        }
    }

    private class FactoryMethodService
    extends SingletonService {
        private final Method method;

        public FactoryMethodService(Method method) {
            super(method.getGenericReturnType());
            this.method = method;
        }

        protected Object create() {
            return DefaultServiceRegistry.invoke(this.method, DefaultServiceRegistry.this, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SingletonService
    extends ManagedObjectProvider<Object> {
        final Type serviceType;
        final Class serviceClass;

        SingletonService(Type type) {
            this.serviceType = type;
            this.serviceClass = this.toClass(type);
        }

        public String toString() {
            return String.format("Service %s", this.serviceType);
        }

        @Override
        public <T> T getService(Class<T> clazz) {
            if (!clazz.isAssignableFrom(this.serviceClass)) {
                return null;
            }
            return clazz.cast(this.getInstance());
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> clazz) {
            if (!Factory.class.isAssignableFrom(this.serviceClass)) {
                return null;
            }
            return this.getFactory(this.serviceType, clazz);
        }

        private <T> Factory<T> getFactory(Type type, Class<T> clazz) {
            Type type2;
            Type[] typeArray;
            Class clazz2 = this.toClass(type);
            if (!Factory.class.isAssignableFrom(clazz2)) {
                return null;
            }
            if (type instanceof ParameterizedType && (typeArray = (Type[])type).getRawType().equals(Factory.class) && (type2 = typeArray.getActualTypeArguments()[0]) instanceof Class && clazz.isAssignableFrom((Class)type2)) {
                Factory factory = this.getService(Factory.class);
                return factory;
            }
            for (Type type3 : clazz2.getGenericInterfaces()) {
                Factory<T> factory = this.getFactory(type3, clazz);
                if (factory == null) continue;
                return factory;
            }
            return null;
        }

        private Class toClass(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ManagedObjectProvider<T>
    implements Provider {
        private T instance;

        private ManagedObjectProvider() {
        }

        public T getInstance() {
            if (this.instance == null) {
                this.instance = this.create();
                assert (this.instance != null) : String.format("create() of %s returned null", this.toString());
            }
            return this.instance;
        }

        protected abstract T create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                new CompositeStoppable(new Object[0]).add(this.instance).stop();
            }
            finally {
                this.instance = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OwnServices
    implements Provider {
        private final List<Provider> providers = new ArrayList<Provider>();

        private OwnServices() {
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> clazz) {
            Factory<T> factory = null;
            for (Provider provider : this.providers) {
                Factory<T> factory2 = provider.getFactory(clazz);
                if (factory2 == null) continue;
                if (factory != null) {
                    throw new IllegalArgumentException(String.format("Multiple factories for objects of type %s available in %s.", clazz.getSimpleName(), DefaultServiceRegistry.this.toString()));
                }
                factory = factory2;
            }
            return factory;
        }

        @Override
        public <T> T getService(Class<T> clazz) {
            T t = null;
            for (Provider provider : this.providers) {
                T t2 = provider.getService(clazz);
                if (t2 == null) continue;
                if (t != null) {
                    throw new IllegalArgumentException(String.format("Multiple services of type %s available in %s.", clazz.getSimpleName(), DefaultServiceRegistry.this.toString()));
                }
                t = t2;
            }
            return t;
        }

        @Override
        public void stop() {
            new CompositeStoppable(this.providers).stop();
        }

        public void add(Provider provider) {
            this.providers.add(provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Provider
    extends Stoppable {
        public <T> T getService(Class<T> var1);

        public <T> Factory<T> getFactory(Class<T> var1);
    }
}

