/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.os;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperatingSystem {
    private static final Windows WINDOWS = new Windows();
    private static final MacOs MAC_OS = new MacOs();
    private static final Solaris SOLARIS = new Solaris();
    private static final Linux LINUX = new Linux();
    private static final Unix UNIX = new Unix();

    public static OperatingSystem current() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("windows")) {
            return WINDOWS;
        }
        if (string.contains("mac os x") || string.contains("darwin")) {
            return MAC_OS;
        }
        if (string.contains("sunos")) {
            return SOLARIS;
        }
        if (string.contains("linux")) {
            return LINUX;
        }
        return UNIX;
    }

    public String toString() {
        return String.format("%s %s %s", this.getName(), this.getVersion(), System.getProperty("os.arch"));
    }

    public String getName() {
        return System.getProperty("os.name");
    }

    public String getVersion() {
        return System.getProperty("os.version");
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isUnix() {
        return false;
    }

    public boolean isMacOsX() {
        return false;
    }

    public boolean isLinux() {
        return false;
    }

    public abstract String getNativePrefix();

    public abstract String getScriptName(String var1);

    public abstract String getExecutableName(String var1);

    public abstract String getSharedLibraryName(String var1);

    public File findInPath(String string) {
        String string2 = this.getExecutableName(string);
        if (string2.contains(File.separator)) {
            File file = new File(string2);
            if (file.isFile()) {
                return file;
            }
            return null;
        }
        for (File file : this.getPath()) {
            File file2 = new File(file, string2);
            if (!file2.isFile()) continue;
            return file2;
        }
        return null;
    }

    public List<File> findAllInPath(String string) {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file : this.getPath()) {
            File file2 = new File(file, string);
            if (!file2.isFile()) continue;
            linkedList.add(file2);
        }
        return linkedList;
    }

    List<File> getPath() {
        String string = System.getenv("PATH");
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : string.split(Pattern.quote(File.pathSeparator))) {
            arrayList.add(new File(string2));
        }
        return arrayList;
    }

    static class Solaris
    extends Unix {
        Solaris() {
        }

        protected String getOsPrefix() {
            return "sunos";
        }

        protected String getArch() {
            String string = System.getProperty("os.arch");
            if (string.equals("i386") || string.equals("x86")) {
                return "x86";
            }
            return super.getArch();
        }
    }

    static class Linux
    extends Unix {
        Linux() {
        }

        public boolean isLinux() {
            return true;
        }
    }

    static class MacOs
    extends Unix {
        MacOs() {
        }

        public boolean isMacOsX() {
            return true;
        }

        protected String getSharedLibSuffix() {
            return ".dylib";
        }

        public String getNativePrefix() {
            return "darwin";
        }
    }

    static class Unix
    extends OperatingSystem {
        Unix() {
        }

        public String getScriptName(String string) {
            return string;
        }

        public String getExecutableName(String string) {
            return string;
        }

        public String getSharedLibraryName(String string) {
            String string2 = this.getSharedLibSuffix();
            if (string.endsWith(string2)) {
                return string;
            }
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                return string.substring(0, n + 1) + "lib" + string.substring(n + 1) + string2;
            }
            return "lib" + string + string2;
        }

        protected String getSharedLibSuffix() {
            return ".so";
        }

        public boolean isUnix() {
            return true;
        }

        public String getNativePrefix() {
            String string = this.getArch();
            String string2 = this.getOsPrefix();
            string2 = string2 + "-" + string;
            return string2;
        }

        protected String getArch() {
            String string = System.getProperty("os.arch");
            if ("x86".equals(string)) {
                string = "i386";
            }
            if ("x86_64".equals(string)) {
                string = "amd64";
            }
            if ("powerpc".equals(string)) {
                string = "ppc";
            }
            return string;
        }

        protected String getOsPrefix() {
            String string = this.getName().toLowerCase();
            int n = string.indexOf(" ");
            if (n != -1) {
                string = string.substring(0, n);
            }
            return string;
        }
    }

    static class Windows
    extends OperatingSystem {
        Windows() {
        }

        public boolean isWindows() {
            return true;
        }

        public String getScriptName(String string) {
            if (string.toLowerCase().endsWith(".bat")) {
                return string;
            }
            return string + ".bat";
        }

        public String getExecutableName(String string) {
            return this.withSuffix(string, ".exe");
        }

        public String getSharedLibraryName(String string) {
            return this.withSuffix(string, ".dll");
        }

        public String getNativePrefix() {
            String string = System.getProperty("os.arch");
            if ("i386".equals(string)) {
                string = "x86";
            }
            return "win32-" + string;
        }

        private String withSuffix(String string, String string2) {
            if (string.toLowerCase().endsWith(string2)) {
                return string;
            }
            return string + string2;
        }
    }
}

