/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.jvm.JavaHomeException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jvm
implements JavaInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jvm.class);
    private final OperatingSystem os;
    private final File javaBase;
    private final File javaHome;
    private final boolean userSupplied;

    public static Jvm current() {
        return Jvm.create(null);
    }

    private static Jvm create(File file) {
        String string = System.getProperty("java.vm.vendor");
        if (string.toLowerCase().startsWith("apple inc.")) {
            return new AppleJvm(OperatingSystem.current(), file);
        }
        if (string.toLowerCase().startsWith("ibm corporation")) {
            return new IbmJvm(OperatingSystem.current(), file);
        }
        return new Jvm(OperatingSystem.current(), file);
    }

    Jvm(OperatingSystem operatingSystem) {
        this(operatingSystem, null);
    }

    Jvm(OperatingSystem operatingSystem, File file) {
        this.os = operatingSystem;
        if (file == null) {
            try {
                this.javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new UncheckedException(iOException);
            }
            this.javaHome = this.findJavaHome(this.javaBase);
            this.userSupplied = false;
        } else {
            this.javaBase = file;
            this.javaHome = file;
            this.userSupplied = true;
        }
    }

    public static JavaInfo forHome(File file) throws JavaHomeException, IllegalArgumentException {
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome must be a valid directory. You supplied: " + file);
        }
        Jvm jvm = Jvm.create(file);
        jvm.getJavaExecutable();
        return jvm;
    }

    public String toString() {
        if (this.userSupplied) {
            return "User-supplied java: " + this.javaBase;
        }
        return String.format("%s (%s %s)", SystemProperties.getJavaVersion(), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version"));
    }

    private File findExecutable(String string) {
        File file = new File(this.getJavaHome(), "bin/" + string);
        File file2 = new File(this.os.getExecutableName(file.getAbsolutePath()));
        if (file2.isFile()) {
            return file2;
        }
        if (this.userSupplied) {
            throw new JavaHomeException(String.format("The supplied javaHome seems to be invalid. I cannot find the %s executable. Tried location: %s", string, file2.getAbsolutePath()));
        }
        File file3 = this.os.findInPath(string);
        if (file3 != null) {
            LOGGER.info(String.format("Unable to find the '%s' executable using home: %s. We found it on the PATH: %s.", string, this.getJavaHome(), file3));
            return file3;
        }
        LOGGER.warn("Unable to find the '{}' executable. Tried the java home: {} and the PATH. We will assume the executable can be ran in the current working folder.", (Object)string, (Object)this.getJavaHome());
        return new File(this.os.getExecutableName(string));
    }

    @Override
    public File getJavaExecutable() throws JavaHomeException {
        return this.findExecutable("java");
    }

    @Override
    public File getJavadocExecutable() throws JavaHomeException {
        return this.findExecutable("javadoc");
    }

    @Override
    public File getExecutable(String string) throws JavaHomeException {
        return this.findExecutable(string);
    }

    public boolean isJava5() {
        return SystemProperties.getJavaVersion().startsWith("1.5");
    }

    public boolean isJava6() {
        return SystemProperties.getJavaVersion().startsWith("1.6");
    }

    public boolean isJava7() {
        return SystemProperties.getJavaVersion().startsWith("1.7");
    }

    public boolean isJava5Compatible() {
        return this.isJava5() || this.isJava6Compatible();
    }

    public boolean isJava6Compatible() {
        return this.isJava6() || this.isJava7();
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    private File findJavaHome(File file) {
        File file2 = this.findToolsJar(file);
        if (file2 != null) {
            return file2.getParentFile().getParentFile();
        }
        if (file.getName().equalsIgnoreCase("jre") && new File(file.getParentFile(), "bin/java").exists()) {
            return file.getParentFile();
        }
        return file;
    }

    @Override
    public File getRuntimeJar() {
        File file = new File(this.javaBase, "lib/rt.jar");
        return file.exists() ? file : null;
    }

    @Override
    public File getToolsJar() {
        return this.findToolsJar(this.javaBase);
    }

    private File findToolsJar(File file) {
        File file2 = new File(file, "lib/tools.jar");
        if (file2.exists()) {
            return file2;
        }
        if (file.getName().equalsIgnoreCase("jre") && (file2 = new File(file = file.getParentFile(), "lib/tools.jar")).exists()) {
            return file2;
        }
        if (file.getName().matches("jre\\d+") && this.os.isWindows() && (file2 = new File(file = new File(file.getParentFile(), String.format("jdk%s", SystemProperties.getJavaVersion())), "lib/tools.jar")).exists()) {
            return file2;
        }
        return null;
    }

    @Override
    public Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> map) {
        return map;
    }

    @Override
    public boolean getSupportsAppleScript() {
        return false;
    }

    public boolean isIbmJvm() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppleJvm
    extends Jvm {
        AppleJvm(OperatingSystem operatingSystem) {
            super(operatingSystem);
        }

        AppleJvm(OperatingSystem operatingSystem, File file) {
            super(operatingSystem, file);
        }

        @Override
        public File getJavaHome() {
            return super.getJavaHome();
        }

        @Override
        public File getRuntimeJar() {
            File file = super.getJavaHome();
            File file2 = new File(file.getParentFile(), "Classes/classes.jar");
            return file2.exists() ? file2 : null;
        }

        @Override
        public File getToolsJar() {
            return this.getRuntimeJar();
        }

        @Override
        public Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> map) {
            HashMap hashMap = new HashMap();
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (entry.getKey().matches("APP_NAME_\\d+") || entry.getKey().matches("JAVA_MAIN_CLASS_\\d+")) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
            return hashMap;
        }

        @Override
        public boolean getSupportsAppleScript() {
            return true;
        }
    }

    static class IbmJvm
    extends Jvm {
        IbmJvm(OperatingSystem operatingSystem, File file) {
            super(operatingSystem, file);
        }

        public boolean isIbmJvm() {
            return true;
        }
    }
}

