/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.internal.Stoppable;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStoppable
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeStoppable.class);
    private final List<Stoppable> elements = new CopyOnWriteArrayList<Stoppable>();

    public CompositeStoppable(Object ... objectArray) {
        this.add(objectArray);
    }

    public CompositeStoppable(Iterable<?> iterable) {
        this.add(iterable);
    }

    public CompositeStoppable add(Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.elements.add(CompositeStoppable.toStoppable(obj));
        }
        return this;
    }

    public CompositeStoppable add(Object ... objectArray) {
        for (Object object : objectArray) {
            this.elements.add(CompositeStoppable.toStoppable(object));
        }
        return this;
    }

    private static Object invoke(Method method, Object object, Object ... objectArray) {
        try {
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw UncheckedException.throwAsUncheckedException(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            throw UncheckedException.throwAsUncheckedException(exception);
        }
    }

    private static Stoppable toStoppable(final Object object) {
        if (object == null) {
            return new Stoppable(){

                public void stop() {
                }
            };
        }
        if (object instanceof Iterable) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        if (object instanceof Stoppable) {
            return (Stoppable)object;
        }
        if (object instanceof Closeable) {
            final Closeable closeable = (Closeable)object;
            return new Stoppable(){

                public String toString() {
                    return closeable.toString();
                }

                public void stop() {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {
                        throw UncheckedException.throwAsUncheckedException(iOException);
                    }
                }
            };
        }
        return new Stoppable(){

            public String toString() {
                return object.toString();
            }

            public void stop() {
                try {
                    CompositeStoppable.invoke(object.getClass().getMethod("stop", new Class[0]), object, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    CompositeStoppable.invoke(object.getClass().getMethod("close", new Class[0]), object, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Throwable throwable = null;
        try {
            for (Stoppable stoppable : this.elements) {
                try {
                    stoppable.stop();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        continue;
                    }
                    LOGGER.error(String.format("Could not stop %s.", stoppable), throwable2);
                }
            }
        }
        finally {
            this.elements.clear();
        }
        if (throwable != null) {
            throw UncheckedException.throwAsUncheckedException(throwable);
        }
    }
}

