/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.github.dependencygraph;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.dependencygraph.model.BuildLayout;
import org.gradle.dependencygraph.model.ResolvedConfiguration;
import org.gradle.dependencygraph.model.ResolvedDependency;
import org.gradle.github.dependencygraph.GitHubRepositorySnapshotBuilder$WhenMappings;
import org.gradle.github.dependencygraph.GitHubSnapshotParams;
import org.gradle.github.dependencygraph.model.GitHubDependency;
import org.gradle.github.dependencygraph.model.GitHubDetector;
import org.gradle.github.dependencygraph.model.GitHubJob;
import org.gradle.github.dependencygraph.model.GitHubManifest;
import org.gradle.github.dependencygraph.model.GitHubManifestFile;
import org.gradle.github.dependencygraph.model.GitHubRepositorySnapshot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gradle/github/dependencygraph/GitHubRepositorySnapshotBuilder;", "", "snapshotParams", "Lorg/gradle/github/dependencygraph/GitHubSnapshotParams;", "(Lorg/gradle/github/dependencygraph/GitHubSnapshotParams;)V", "detector", "Lorg/gradle/github/dependencygraph/model/GitHubDetector;", "getDetector", "()Lorg/gradle/github/dependencygraph/model/GitHubDetector;", "detector$delegate", "Lkotlin/Lazy;", "job", "Lorg/gradle/github/dependencygraph/model/GitHubJob;", "getJob", "()Lorg/gradle/github/dependencygraph/model/GitHubJob;", "job$delegate", "buildManifest", "Lorg/gradle/github/dependencygraph/model/GitHubManifest;", "manifestName", "", "resolvedConfigurations", "", "Lorg/gradle/dependencygraph/model/ResolvedConfiguration;", "buildLayout", "Lorg/gradle/dependencygraph/model/BuildLayout;", "buildSnapshot", "Lorg/gradle/github/dependencygraph/model/GitHubRepositorySnapshot;", "manifest", "determineGitHubScope", "Lorg/gradle/github/dependencygraph/model/GitHubDependency$Scope;", "configuration", "getManifestFile", "Lorg/gradle/github/dependencygraph/model/GitHubManifestFile;", "DependencyCollector", "plugin"})
public final class GitHubRepositorySnapshotBuilder {
    private final Lazy detector$delegate;
    private final Lazy job$delegate;
    private final GitHubSnapshotParams snapshotParams;

    private final GitHubDetector getDetector() {
        Lazy lazy = this.detector$delegate;
        GitHubRepositorySnapshotBuilder gitHubRepositorySnapshotBuilder = this;
        Object var3_3 = null;
        return (GitHubDetector)lazy.getValue();
    }

    private final GitHubJob getJob() {
        Lazy lazy = this.job$delegate;
        GitHubRepositorySnapshotBuilder gitHubRepositorySnapshotBuilder = this;
        Object var3_3 = null;
        return (GitHubJob)lazy.getValue();
    }

    @NotNull
    public final GitHubManifest buildManifest(@NotNull String manifestName, @NotNull List<ResolvedConfiguration> resolvedConfigurations, @NotNull BuildLayout buildLayout) {
        Intrinsics.checkParameterIsNotNull((Object)manifestName, (String)"manifestName");
        Intrinsics.checkParameterIsNotNull(resolvedConfigurations, (String)"resolvedConfigurations");
        Intrinsics.checkParameterIsNotNull((Object)buildLayout, (String)"buildLayout");
        DependencyCollector dependencyCollector = new DependencyCollector();
        for (ResolvedConfiguration configuration : resolvedConfigurations) {
            for (ResolvedDependency dependency : configuration.getAllDependencies()) {
                if (dependency.isProject()) continue;
                dependencyCollector.addResolved(dependency, this.determineGitHubScope(configuration));
            }
        }
        return new GitHubManifest(manifestName, dependencyCollector.getDependencies(), this.getManifestFile(buildLayout));
    }

    private final GitHubDependency.Scope determineGitHubScope(ResolvedConfiguration configuration) {
        GitHubDependency.Scope scope;
        switch (GitHubRepositorySnapshotBuilder$WhenMappings.$EnumSwitchMapping$0[configuration.getScope().ordinal()]) {
            case 1: {
                scope = GitHubDependency.Scope.development;
                break;
            }
            case 2: {
                scope = GitHubDependency.Scope.runtime;
                break;
            }
            case 3: {
                scope = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return scope;
    }

    private final GitHubManifestFile getManifestFile(BuildLayout buildLayout) {
        GitHubManifestFile gitHubManifestFile;
        Path path;
        Path path2 = path = buildLayout.getRootBuildPath();
        if (path2 != null) {
            Path path3;
            Path it = path3 = path2;
            boolean bl = false;
            String filePath = StringsKt.replace$default((String)((Object)this.snapshotParams.getGitHubWorkspace().relativize(path)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            gitHubManifestFile = new GitHubManifestFile(filePath);
        } else {
            gitHubManifestFile = null;
        }
        return gitHubManifestFile;
    }

    @NotNull
    public final GitHubRepositorySnapshot buildSnapshot(@NotNull GitHubManifest manifest) {
        Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        return new GitHubRepositorySnapshot(0, this.getJob(), this.snapshotParams.getGitSha(), this.snapshotParams.getGitRef(), this.getDetector(), MapsKt.mapOf((Pair)TuplesKt.to((Object)manifest.getName(), (Object)manifest)), null, 65, null);
    }

    public GitHubRepositorySnapshotBuilder(@NotNull GitHubSnapshotParams snapshotParams) {
        Intrinsics.checkParameterIsNotNull((Object)snapshotParams, (String)"snapshotParams");
        this.snapshotParams = snapshotParams;
        this.detector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GitHubDetector>(this){
            final /* synthetic */ GitHubRepositorySnapshotBuilder this$0;

            @NotNull
            public final GitHubDetector invoke() {
                return new GitHubDetector(GitHubRepositorySnapshotBuilder.access$getSnapshotParams$p(this.this$0).getGithubDetectorName(), GitHubRepositorySnapshotBuilder.access$getSnapshotParams$p(this.this$0).getGithubDetectorVersion(), GitHubRepositorySnapshotBuilder.access$getSnapshotParams$p(this.this$0).getGithubDetectorUrl());
            }
            {
                this.this$0 = gitHubRepositorySnapshotBuilder;
                super(0);
            }
        }));
        this.job$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GitHubJob>(this){
            final /* synthetic */ GitHubRepositorySnapshotBuilder this$0;

            @NotNull
            public final GitHubJob invoke() {
                return new GitHubJob(GitHubRepositorySnapshotBuilder.access$getSnapshotParams$p(this.this$0).getDependencyGraphJobId(), GitHubRepositorySnapshotBuilder.access$getSnapshotParams$p(this.this$0).getDependencyGraphJobCorrelator());
            }
            {
                this.this$0 = gitHubRepositorySnapshotBuilder;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ GitHubSnapshotParams access$getSnapshotParams$p(GitHubRepositorySnapshotBuilder $this) {
        return $this.snapshotParams;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gradle/github/dependencygraph/GitHubRepositorySnapshotBuilder$DependencyCollector;", "", "()V", "dependencyBuilders", "", "", "Lorg/gradle/github/dependencygraph/GitHubRepositorySnapshotBuilder$DependencyCollector$GitHubDependencyBuilder;", "addResolved", "", "component", "Lorg/gradle/dependencygraph/model/ResolvedDependency;", "scope", "Lorg/gradle/github/dependencygraph/model/GitHubDependency$Scope;", "getDependencies", "", "Lorg/gradle/github/dependencygraph/model/GitHubDependency;", "relationship", "Lorg/gradle/github/dependencygraph/model/GitHubDependency$Relationship;", "GitHubDependencyBuilder", "plugin"})
    @SourceDebugExtension(value={"SMAP\nGitHubRepositorySnapshotBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubRepositorySnapshotBuilder.kt\norg/gradle/github/dependencygraph/GitHubRepositorySnapshotBuilder$DependencyCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n372#2,7:140\n453#2:147\n403#2:148\n1238#3,4:149\n*E\n*S KotlinDebug\n*F\n+ 1 GitHubRepositorySnapshotBuilder.kt\norg/gradle/github/dependencygraph/GitHubRepositorySnapshotBuilder$DependencyCollector\n*L\n86#1,7:140\n98#1:147\n98#1:148\n98#1,4:149\n*E\n"})
    private static final class DependencyCollector {
        private final Map<String, GitHubDependencyBuilder> dependencyBuilders = new LinkedHashMap();

        /*
         * WARNING - void declaration
         */
        public final void addResolved(@NotNull ResolvedDependency component, @Nullable GitHubDependency.Scope scope) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            Map<String, GitHubDependencyBuilder> map = this.dependencyBuilders;
            String key$iv = component.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                GitHubDependencyBuilder answer$iv = new GitHubDependencyBuilder(component.packageUrl());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            GitHubDependencyBuilder dep = (GitHubDependencyBuilder)object;
            dep.addRelationship(this.relationship(component));
            dep.addScope(scope);
            dep.addDependencies(component.getDependencies());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, GitHubDependency> getDependencies() {
            void $this$mapValuesTo$iv$iv;
            Map<String, GitHubDependencyBuilder> $this$mapValues$iv = this.dependencyBuilders;
            boolean $i$f$mapValues = false;
            Map<String, GitHubDependencyBuilder> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $dstr$_u24__u24$builder;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                void var15_15 = $dstr$_u24__u24$builder;
                GitHubDependencyBuilder builder = (GitHubDependencyBuilder)var15_15.getValue();
                GitHubDependency gitHubDependency = builder.build();
                map3.put(k, gitHubDependency);
            }
            return destination$iv$iv;
        }

        private final GitHubDependency.Relationship relationship(ResolvedDependency component) {
            return component.isDirect() ? GitHubDependency.Relationship.direct : GitHubDependency.Relationship.indirect;
        }

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u001f\u001a\u00020 R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/gradle/github/dependencygraph/GitHubRepositorySnapshotBuilder$DependencyCollector$GitHubDependencyBuilder;", "", "package_url", "", "(Ljava/lang/String;)V", "dependencies", "", "getDependencies", "()Ljava/util/List;", "getPackage_url", "()Ljava/lang/String;", "relationship", "Lorg/gradle/github/dependencygraph/model/GitHubDependency$Relationship;", "getRelationship", "()Lorg/gradle/github/dependencygraph/model/GitHubDependency$Relationship;", "setRelationship", "(Lorg/gradle/github/dependencygraph/model/GitHubDependency$Relationship;)V", "scope", "Lorg/gradle/github/dependencygraph/model/GitHubDependency$Scope;", "getScope", "()Lorg/gradle/github/dependencygraph/model/GitHubDependency$Scope;", "setScope", "(Lorg/gradle/github/dependencygraph/model/GitHubDependency$Scope;)V", "addDependencies", "", "newDependencies", "", "addRelationship", "newRelationship", "addScope", "newScope", "build", "Lorg/gradle/github/dependencygraph/model/GitHubDependency;", "plugin"})
        private static final class GitHubDependencyBuilder {
            @NotNull
            private GitHubDependency.Relationship relationship;
            @Nullable
            private GitHubDependency.Scope scope;
            @NotNull
            private final List<String> dependencies;
            @NotNull
            private final String package_url;

            @NotNull
            public final GitHubDependency.Relationship getRelationship() {
                return this.relationship;
            }

            public final void setRelationship(@NotNull GitHubDependency.Relationship relationship) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)relationship), (String)"<set-?>");
                this.relationship = relationship;
            }

            @Nullable
            public final GitHubDependency.Scope getScope() {
                return this.scope;
            }

            public final void setScope(@Nullable GitHubDependency.Scope scope) {
                this.scope = scope;
            }

            @NotNull
            public final List<String> getDependencies() {
                return this.dependencies;
            }

            public final void addRelationship(@NotNull GitHubDependency.Relationship newRelationship) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)newRelationship), (String)"newRelationship");
                if (this.relationship == GitHubDependency.Relationship.indirect) {
                    this.relationship = newRelationship;
                }
            }

            public final void addScope(@Nullable GitHubDependency.Scope newScope) {
                if (newScope == null) {
                    return;
                }
                if (this.scope == null || this.scope == GitHubDependency.Scope.development) {
                    this.scope = newScope;
                }
            }

            public final void addDependencies(@NotNull List<String> newDependencies) {
                Intrinsics.checkParameterIsNotNull(newDependencies, (String)"newDependencies");
                for (String newDependency : CollectionsKt.subtract((Iterable)newDependencies, (Iterable)CollectionsKt.toSet((Iterable)this.dependencies))) {
                    this.dependencies.add(newDependency);
                }
            }

            @NotNull
            public final GitHubDependency build() {
                return new GitHubDependency(this.package_url, this.relationship, this.scope, this.dependencies);
            }

            @NotNull
            public final String getPackage_url() {
                return this.package_url;
            }

            public GitHubDependencyBuilder(@NotNull String package_url) {
                Intrinsics.checkParameterIsNotNull((Object)package_url, (String)"package_url");
                this.package_url = package_url;
                this.relationship = GitHubDependency.Relationship.indirect;
                this.dependencies = new ArrayList();
            }
        }
    }
}

