/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.dependencygraph.simple;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.dependencygraph.DependencyGraphRenderer;
import org.gradle.dependencygraph.model.BuildLayout;
import org.gradle.dependencygraph.model.DependencyScope;
import org.gradle.dependencygraph.model.ResolvedConfiguration;
import org.gradle.dependencygraph.model.ResolvedDependency;
import org.gradle.dependencygraph.simple.SimpleDependency;
import org.gradle.dependencygraph.simple.SimpleDependencyResolution;
import org.gradle.dependencygraph.util.JacksonJsonSerializer;
import org.gradle.dependencygraph.util.PluginParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/gradle/dependencygraph/simple/SimpleDependencyGraphRenderer;", "Lorg/gradle/dependencygraph/DependencyGraphRenderer;", "()V", "outputDependencyGraph", "", "outputDirectory", "Ljava/io/File;", "resolvedConfigurations", "", "Lorg/gradle/dependencygraph/model/ResolvedConfiguration;", "pluginParameters", "Lorg/gradle/dependencygraph/util/PluginParameters;", "buildLayout", "Lorg/gradle/dependencygraph/model/BuildLayout;", "outputDependencyList", "outputDependencyScopes", "plugin"})
@SourceDebugExtension(value={"SMAP\nSimpleDependencyGraphRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleDependencyGraphRenderer.kt\norg/gradle/dependencygraph/simple/SimpleDependencyGraphRenderer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n372#2,7:91\n125#3:98\n152#3,2:99\n154#3:105\n1549#4:101\n1620#4,3:102\n1360#4:106\n1446#4,2:107\n1549#4:109\n1620#4,3:110\n1448#4,3:113\n*E\n*S KotlinDebug\n*F\n+ 1 SimpleDependencyGraphRenderer.kt\norg/gradle/dependencygraph/simple/SimpleDependencyGraphRenderer\n*L\n49#1,7:91\n60#1:98\n60#1,2:99\n60#1:105\n61#1:101\n61#1,3:102\n72#1:106\n72#1,2:107\n73#1:109\n73#1,3:110\n72#1,3:113\n*E\n"})
public final class SimpleDependencyGraphRenderer
implements DependencyGraphRenderer {
    @Override
    public void outputDependencyGraph(@NotNull PluginParameters pluginParameters, @NotNull BuildLayout buildLayout, @NotNull List<ResolvedConfiguration> resolvedConfigurations, @NotNull File outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)pluginParameters, (String)"pluginParameters");
        Intrinsics.checkParameterIsNotNull((Object)buildLayout, (String)"buildLayout");
        Intrinsics.checkParameterIsNotNull(resolvedConfigurations, (String)"resolvedConfigurations");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        this.outputDependencyGraph(outputDirectory, resolvedConfigurations);
        this.outputDependencyScopes(outputDirectory, resolvedConfigurations);
        this.outputDependencyList(outputDirectory, resolvedConfigurations);
    }

    private final void outputDependencyGraph(File outputDirectory, List<ResolvedConfiguration> resolvedConfigurations) {
        File outputFile = new File(outputDirectory, "dependency-graph.json");
        String jsonContent = JacksonJsonSerializer.INSTANCE.serializeToJson(resolvedConfigurations);
        FilesKt.writeText$default((File)outputFile, (String)jsonContent, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void outputDependencyScopes(File outputDirectory, List<ResolvedConfiguration> resolvedConfigurations) {
        void $this$mapTo$iv$iv;
        Object value$iv;
        File outputFile = new File(outputDirectory, "dependency-resolution.json");
        Map dependencyList = new LinkedHashMap();
        for (ResolvedConfiguration config : resolvedConfigurations) {
            for (ResolvedDependency dependency : config.getAllDependencies()) {
                Object object;
                void $this$getOrPut$iv;
                if (dependency.isProject()) continue;
                Map map = dependencyList;
                String key$iv = dependency.getId();
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Set dependencyResolutions = (Set)object;
                dependencyResolutions.add(new SimpleDependencyResolution(config.getRootOrigin().getPath(), config.getConfigurationName(), config.getScope()));
            }
        }
        Map $this$map$iv = dependencyList;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            Collection<DependencyScope> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void id;
            void $dstr$id$resolutions;
            value$iv = item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable = $dstr$id$resolutions;
            String string = (String)iterable.getKey();
            iterable = $dstr$id$resolutions;
            Set resolutions = (Set)iterable.getValue();
            iterable = resolutions;
            DependencyScope.Companion companion = DependencyScope.Companion;
            void var19_24 = id;
            boolean $i$f$map2 = false;
            void var21_26 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                SimpleDependencyResolution simpleDependencyResolution = (SimpleDependencyResolution)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                DependencyScope dependencyScope = it.getScope();
                collection.add(dependencyScope);
            }
            collection = (List)destination$iv$iv2;
            List list = CollectionsKt.toList((Iterable)resolutions);
            DependencyScope dependencyScope = companion.getEffectiveScope((List<? extends DependencyScope>)collection);
            void var34_39 = var19_24;
            SimpleDependency simpleDependency = new SimpleDependency((String)var34_39, dependencyScope, list);
            collection2.add(simpleDependency);
        }
        List simpleDependencies = (List)destination$iv$iv;
        String jsonContent = JacksonJsonSerializer.INSTANCE.serializeToJson(simpleDependencies);
        FilesKt.writeText$default((File)outputFile, (String)jsonContent, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void outputDependencyList(File outputDirectory, List<ResolvedConfiguration> resolvedConfigurations) {
        void $this$flatMapTo$iv$iv;
        File outputFile = new File(outputDirectory, "dependency-list.txt");
        Iterable $this$flatMap$iv = resolvedConfigurations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ResolvedConfiguration config = (ResolvedConfiguration)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = config.getAllDependencies();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResolvedDependency resolvedDependency = (ResolvedDependency)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = it.getCoordinates().getGroup() + ':' + it.getCoordinates().getModule() + ':' + it.getCoordinates().getVersion();
                collection.add(string);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List dependencyList = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        String listTxt = CollectionsKt.joinToString$default((Iterable)dependencyList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        FilesKt.writeText$default((File)outputFile, (String)listTxt, null, (int)2, null);
    }
}

