/*
 * Decompiled with CFR 0.152.
 */
package org.gradlewebtools.minify.minifier.css;

import com.google.common.css.GssFunctionMapProvider;
import com.google.common.css.IdentitySubstitutionMap;
import com.google.common.css.JobDescription;
import com.google.common.css.JobDescriptionBuilder;
import com.google.common.css.SourceCode;
import com.google.common.css.SubstitutionMap;
import com.google.common.css.compiler.ClosureStylesheetCompiler;
import com.google.common.css.compiler.ast.BasicErrorManager;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.gssfunctions.DefaultGssFunctionMapProvider;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradlewebtools.minify.minifier.Minifier;
import org.gradlewebtools.minify.minifier.css.CssMinifierOptions;
import org.gradlewebtools.minify.minifier.result.Error;
import org.gradlewebtools.minify.minifier.result.Warning;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/gradlewebtools/minify/minifier/css/CssMinifier;", "Lorg/gradlewebtools/minify/minifier/Minifier;", "minifierOptions", "Lorg/gradlewebtools/minify/minifier/css/CssMinifierOptions;", "<init>", "(Lorg/gradlewebtools/minify/minifier/css/CssMinifierOptions;)V", "getMinifierOptions", "()Lorg/gradlewebtools/minify/minifier/css/CssMinifierOptions;", "setMinifierOptions", "minifierName", "", "getMinifierName", "()Ljava/lang/String;", "acceptedFileExtensions", "", "getAcceptedFileExtensions", "()Ljava/util/List;", "minifyFile", "", "srcFile", "Ljava/io/File;", "dstFile", "rename", "oldName", "createJobDescription", "Lcom/google/common/css/JobDescription;", "file", "CompilerErrorManager", "gradle-minify-plugin"})
public final class CssMinifier
extends Minifier {
    @NotNull
    private CssMinifierOptions minifierOptions;
    @NotNull
    private final String minifierName;
    @NotNull
    private final List<String> acceptedFileExtensions;

    public CssMinifier(@NotNull CssMinifierOptions minifierOptions) {
        Intrinsics.checkNotNullParameter((Object)minifierOptions, (String)"minifierOptions");
        this.minifierOptions = minifierOptions;
        this.minifierName = "Css Minifier";
        this.acceptedFileExtensions = CollectionsKt.listOf((Object)"css");
    }

    public /* synthetic */ CssMinifier(CssMinifierOptions cssMinifierOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            cssMinifierOptions = new CssMinifierOptions(null, null, null, null, null, false, false, null, null, false, null, false, false, false, null, false, false, null, false, null, null, null, 0x3FFFFF, null);
        }
        this(cssMinifierOptions);
    }

    @Override
    @NotNull
    public CssMinifierOptions getMinifierOptions() {
        return this.minifierOptions;
    }

    public void setMinifierOptions(@NotNull CssMinifierOptions cssMinifierOptions) {
        Intrinsics.checkNotNullParameter((Object)cssMinifierOptions, (String)"<set-?>");
        this.minifierOptions = cssMinifierOptions;
    }

    @Override
    @NotNull
    public String getMinifierName() {
        return this.minifierName;
    }

    @Override
    @NotNull
    public List<String> getAcceptedFileExtensions() {
        return this.acceptedFileExtensions;
    }

    @Override
    protected void minifyFile(@NotNull File srcFile, @NotNull File dstFile) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
        try {
            JobDescription job = this.createJobDescription(srcFile);
            CompilerErrorManager errorManager = new CompilerErrorManager();
            ClosureStylesheetCompiler compiler = new ClosureStylesheetCompiler(job, (ErrorManager)errorManager);
            File sourcemapFile = null;
            if (this.getMinifierOptions().getCreateSourceMaps()) {
                sourcemapFile = new File(dstFile.getAbsolutePath() + ".map");
            }
            Object compilerOutput = compiler.execute(null, sourcemapFile);
            if (sourcemapFile != null) {
                compilerOutput = (String)compilerOutput + "\n//# sourceMappingURL=" + sourcemapFile.getName();
            }
            String string = compilerOutput;
            Intrinsics.checkNotNull((Object)string);
            this.writeToFile(dstFile, string);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @NotNull
    protected String rename(@NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        return StringsKt.replace$default((String)oldName, (String)".css", (String)".min.css", (boolean)false, (int)4, null);
    }

    private final JobDescription createJobDescription(File file) throws IOException {
        JobDescriptionBuilder builder = new JobDescriptionBuilder();
        builder.setInputOrientation(this.getMinifierOptions().getInputOrientation());
        builder.setOutputOrientation(this.getMinifierOptions().getOutputOrientation());
        builder.setOutputFormat(this.getMinifierOptions().getOutputFormat());
        builder.setCopyrightNotice(this.getMinifierOptions().getCopyrightNotice());
        builder.setTrueConditionNames(this.getMinifierOptions().getTrueConditionNames());
        builder.setAllowDefPropagation(this.getMinifierOptions().getAllowDefPropagation());
        builder.setAllowUnrecognizedFunctions(this.getMinifierOptions().getAllowUnrecognizedFunctions());
        builder.setAllowedNonStandardFunctions(this.getMinifierOptions().getAllowedNonStandardFunctions());
        builder.setAllowedUnrecognizedProperties(this.getMinifierOptions().getAllowedUnrecognizedProperties());
        builder.setAllowUnrecognizedProperties(this.getMinifierOptions().getAllowUnrecognizedProperties());
        builder.setVendor(this.getMinifierOptions().getVendor());
        builder.setAllowKeyframes(this.getMinifierOptions().getAllowKeyframes());
        builder.setAllowWebkitKeyframes(this.getMinifierOptions().getAllowWebkitKeyframes());
        builder.setProcessDependencies(this.getMinifierOptions().getProcessDependencies());
        builder.setExcludedClassesFromRenaming(this.getMinifierOptions().getExcludedClassesFromRenaming());
        builder.setSimplifyCss(this.getMinifierOptions().getSimplifyCss());
        builder.setEliminateDeadStyles(this.getMinifierOptions().getEliminateDeadStyles());
        builder.setCssSubstitutionMapProvider(CssMinifier::createJobDescription$lambda$0);
        builder.setCssRenamingPrefix(this.getMinifierOptions().getCssRenamingPrefix());
        builder.setPreserveComments(this.getMinifierOptions().getPreserveComments());
        builder.setOutputRenamingMapFormat(this.getMinifierOptions().getOutputRenamingMapFormat());
        builder.setCompileConstants(this.getMinifierOptions().getCompileConstants());
        builder.setGssFunctionMapProvider((GssFunctionMapProvider)new DefaultGssFunctionMapProvider());
        builder.setSourceMapLevel(this.getMinifierOptions().getSourceMapLevel());
        builder.setCreateSourceMap(this.getMinifierOptions().getCreateSourceMaps());
        byte[] byArray = Files.readAllBytes(file.toPath());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] byArray2 = byArray;
        String fileContents = new String(byArray2, Charsets.UTF_8);
        builder.addInput(new SourceCode(file.getName(), fileContents));
        JobDescription jobDescription = builder.getJobDescription();
        Intrinsics.checkNotNullExpressionValue((Object)jobDescription, (String)"getJobDescription(...)");
        return jobDescription;
    }

    private static final SubstitutionMap createJobDescription$lambda$0() {
        return (SubstitutionMap)new IdentitySubstitutionMap();
    }

    public CssMinifier() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/gradlewebtools/minify/minifier/css/CssMinifier$CompilerErrorManager;", "Lcom/google/common/css/compiler/ast/BasicErrorManager;", "<init>", "(Lorg/gradlewebtools/minify/minifier/css/CssMinifier;)V", "print", "", "msg", "", "report", "error", "Lcom/google/common/css/compiler/ast/GssError;", "reportWarning", "warning", "gradle-minify-plugin"})
    public final class CompilerErrorManager
    extends BasicErrorManager {
        public void print(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        }

        public void report(@NotNull GssError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            CssMinifier.this.getReport().add(new Error(error));
        }

        public void reportWarning(@NotNull GssError warning) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            CssMinifier.this.getReport().add(new Warning(warning));
        }
    }
}

