/*
 * Decompiled with CFR 0.152.
 */
package org.gradlewebtools.minify.minifier;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradlewebtools.minify.minifier.MinifierOptions;
import org.gradlewebtools.minify.minifier.result.Error;
import org.gradlewebtools.minify.minifier.result.Event;
import org.gradlewebtools.minify.minifier.result.Report;
import org.gradlewebtools.minify.minifier.result.Warning;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019H$J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H$J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0005H\u0004R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lorg/gradlewebtools/minify/minifier/Minifier;", "", "()V", "acceptedFileExtensions", "", "", "getAcceptedFileExtensions", "()Ljava/util/List;", "minifierName", "getMinifierName", "()Ljava/lang/String;", "minifierOptions", "Lorg/gradlewebtools/minify/minifier/MinifierOptions;", "getMinifierOptions", "()Lorg/gradlewebtools/minify/minifier/MinifierOptions;", "report", "Lorg/gradlewebtools/minify/minifier/result/Report;", "getReport", "()Lorg/gradlewebtools/minify/minifier/result/Report;", "createReport", "handleFile", "", "f", "Ljava/nio/file/Path;", "dstDir", "Ljava/io/File;", "it", "minify", "srcDir", "minifyFile", "srcFile", "dstFile", "minifyFileInternal", "minifyInternal", "rename", "oldName", "shouldMinify", "", "writeToFile", "string", "Companion", "gradle-minify-plugin"})
public abstract class Minifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Report report = new Report();
    private static final Logger LOGGER = LoggerFactory.getLogger(Minifier.class);

    @NotNull
    public abstract List<String> getAcceptedFileExtensions();

    @NotNull
    public abstract String getMinifierName();

    @NotNull
    public abstract MinifierOptions getMinifierOptions();

    @NotNull
    public final Report getReport() {
        return this.report;
    }

    public final void minify(@NotNull File srcDir, @NotNull File dstDir) {
        Intrinsics.checkNotNullParameter((Object)srcDir, (String)"srcDir");
        Intrinsics.checkNotNullParameter((Object)dstDir, (String)"dstDir");
        this.minifyInternal(srcDir, dstDir);
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(this.createReport());
        }
        Collection collection = this.report.getErrors();
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw new GradleException(this.report.getErrors() + " Errors in " + this.getMinifierName());
        }
    }

    private final void minifyInternal(File srcDir, File dstDir) {
        try {
            File[] fileArray = srcDir.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    Path f = it.toPath();
                    if (it.isFile()) {
                        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.handleFile(f, dstDir, it);
                        continue;
                    }
                    if (!it.isDirectory()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.minifyInternal(it, new File(dstDir, ((Object)f.getFileName()).toString()));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final boolean shouldMinify(Path f) {
        return !this.getMinifierOptions().getIgnoreMinFiles() || !StringsKt.contains$default((CharSequence)((Object)f.getFileName()).toString(), (CharSequence)".min.", (boolean)false, (int)2, null);
    }

    private final void handleFile(Path f, File dstDir, File it) {
        Object v0;
        CopyOption[] copyOptionArray;
        File dstFile;
        File copy;
        block5: {
            Path dst = dstDir.toPath();
            String fileName = ((Object)f.getFileName()).toString();
            copy = new File(((Object)dst).toString(), fileName);
            if (!this.getMinifierOptions().getOriginalFileNames()) {
                fileName = this.rename(fileName);
            }
            dstFile = new File(((Object)dst).toString(), fileName);
            dstFile.getParentFile().mkdirs();
            copyOptionArray = (CopyOption[])this.getAcceptedFileExtensions();
            boolean bl = false;
            CopyOption[] copyOptionArray2 = copyOptionArray;
            boolean bl2 = false;
            for (Object t : copyOptionArray2) {
                String ext = (String)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)ext, (Object)FilesKt.getExtension((File)it))) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        if (v0 != null) {
            if (this.getMinifierOptions().getCopyOriginalFile() && !this.getMinifierOptions().getOriginalFileNames() || !this.shouldMinify(f)) {
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(f, copy.toPath(), copyOptionArray);
            }
            if (this.shouldMinify(f)) {
                copyOptionArray = f.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)copyOptionArray, (String)"f.toFile()");
                this.minifyFileInternal((File)copyOptionArray, dstFile);
            }
        }
    }

    private final void minifyFileInternal(File srcFile, File dstFile) {
        try {
            this.minifyFile(srcFile, dstFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final String createReport() {
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2;
        String string;
        StringBuilder stringBuilder2;
        Event it;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder3 = new StringBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        StringBuilder $this$createReport_u24lambda_u2d4 = stringBuilder3;
        boolean bl7 = false;
        Iterable $this$forEach$iv = this.getReport().getErrors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Error)element$iv;
            boolean bl8 = false;
            stringBuilder2 = $this$createReport_u24lambda_u2d4;
            string = Intrinsics.stringPlus((String)"Error: ", (Object)it);
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(string), (String)"append(value)");
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        $this$forEach$iv = this.getReport().getWarnings();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Warning)element$iv;
            boolean bl9 = false;
            stringBuilder2 = $this$createReport_u24lambda_u2d4;
            string = Intrinsics.stringPlus((String)"Warning: ", (Object)it);
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append(string), (String)"append(value)");
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder4 = $this$createReport_u24lambda_u2d4;
        String string2 = this.getMinifierName() + ": " + this.getReport().getErrors().size() + " error(s), " + this.getReport().getWarnings().size() + " warning(s)";
        boolean bl10 = false;
        StringBuilder stringBuilder5 = stringBuilder4.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringBuilder stringBuilder6 = stringBuilder5;
        boolean bl11 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        String string3 = stringBuilder3.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    protected final void writeToFile(@NotNull File dstFile, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        try {
            Object object = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            StandardOpenOption[] options2 = object;
            Path path = dstFile.toPath();
            object = string;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            Files.write(path, byArray, (OpenOption[])Arrays.copyOf(options2, options2.length));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract void minifyFile(@NotNull File var1, @NotNull File var2);

    @NotNull
    protected abstract String rename(@NotNull String var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gradlewebtools/minify/minifier/Minifier$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "gradle-minify-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

