/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Eventtype;

public final class Event {
    public static final int BYTES = 32;

    private Event() {
    }

    public static long readUserdata(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 0);
    }

    public static void writeUserdata(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 0, value);
    }

    public static Errno readError(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return Errno.fromValue((short)memoryLib.load_i32_16u(memory, node, address + 8));
    }

    public static void writeError(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, Errno value) {
        memoryLib.store_i32_16(memory, node, address + 8, value.toValue());
    }

    public static Eventtype readType(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return Eventtype.fromValue((byte)memoryLib.load_i32_8u(memory, node, address + 10));
    }

    public static void writeType(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, Eventtype value) {
        memoryLib.store_i32_8(memory, node, address + 10, value.toValue());
    }

    public static int readFdReadwrite(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i32(memory, node, address + 16);
    }

    public static void writeFdReadwrite(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, int value) {
        memoryLib.store_i32(memory, node, address + 16, value);
    }
}

