/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiArgsGetNode
extends WasmBuiltinRootNode {
    public WasiArgsGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.argsGet(this.getContext(), this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    private int argsGet(WasmContext context, WasmMemory memory, int argvAddress, int argvBuffAddress) {
        String[] arguments = context.environment().getApplicationArguments();
        int argvPointer = argvAddress;
        int argvBuffPointer = argvBuffAddress;
        for (String argument : arguments) {
            this.memoryLib.store_i32(memory, (Node)this, argvPointer, argvBuffPointer);
            argvPointer += 4;
            argvBuffPointer += memory.writeString((Node)this, argument, argvBuffPointer);
            this.memoryLib.store_i32_8(memory, (Node)this, argvBuffPointer, (byte)0);
            ++argvBuffPointer;
        }
        return Errno.Success.ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_args_get";
    }
}

