/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.emscripten;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;

public class LLVMExp2F64Node
extends WasmBuiltinRootNode {
    public LLVMExp2F64Node(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        assert (WasmArguments.getArgumentCount(args) == 1);
        double x = (Double)WasmArguments.getArgument(args, 0);
        return this.exp2(x);
    }

    @Override
    public String builtinNodeName() {
        return "_llvm_exp2_f64";
    }

    @CompilerDirectives.TruffleBoundary
    double exp2(double x) {
        return Math.pow(2.0, x);
    }
}

