/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.emscripten;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;

public class GetTimeOfDayNode
extends WasmBuiltinRootNode {
    public GetTimeOfDayNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        assert (WasmArguments.getArgumentCount(args) == 2);
        int ptr = (Integer)WasmArguments.getArgument(args, 0);
        long now = GetTimeOfDayNode.getCurrentTime();
        WasmMemory memory = this.memory(frame);
        this.memoryLib.store_i32(memory, (Node)this, ptr, (int)(now / 1000L));
        this.memoryLib.store_i32(memory, (Node)this, ptr + 4, (int)(now % 1000L * 1000L));
        return 0;
    }

    @Override
    public String builtinNodeName() {
        return "_gettimeofday";
    }

    @CompilerDirectives.TruffleBoundary
    private static long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

