/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.validation;

import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.parser.bytecode.RuntimeBytecodeGen;
import org.graalvm.wasm.parser.validation.ControlFrame;
import org.graalvm.wasm.parser.validation.ParserState;

class LoopFrame
extends ControlFrame {
    private final int labelLocation;

    LoopFrame(byte[] paramTypes, byte[] resultTypes, int initialStackSize, boolean unreachable, int labelLocation) {
        super(paramTypes, resultTypes, initialStackSize, unreachable);
        this.labelLocation = labelLocation;
    }

    @Override
    byte[] labelTypes() {
        return this.paramTypes();
    }

    @Override
    void enterElse(ParserState state, RuntimeBytecodeGen bytecode) {
        throw WasmException.create(Failure.TYPE_MISMATCH, "Expected then branch. Else branch requires preceding then branch.");
    }

    @Override
    void exit(RuntimeBytecodeGen bytecode) {
    }

    @Override
    void addBranch(RuntimeBytecodeGen bytecode) {
        bytecode.addBranch(this.labelLocation);
    }

    @Override
    void addBranchIf(RuntimeBytecodeGen bytecode) {
        bytecode.addBranchIf(this.labelLocation);
    }

    @Override
    void addBranchTableItem(RuntimeBytecodeGen bytecode) {
        bytecode.patchLocation(bytecode.addBranchTableItemLocation(), this.labelLocation);
    }
}

