/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.parser.bytecode.BytecodeGen;

public class RuntimeBytecodeGen
extends BytecodeGen {
    private static boolean fitsIntoSignedByte(int value) {
        return value >= -128 && value <= 127;
    }

    private static boolean fitsIntoSignedByte(long value) {
        return value >= -128L && value <= 127L;
    }

    private static boolean fitsIntoSixBits(int value) {
        return Integer.compareUnsigned(value, 63) <= 0;
    }

    private static boolean fitsIntoUnsignedByte(int value) {
        return Integer.compareUnsigned(value, 255) <= 0;
    }

    private static boolean fitsIntoUnsignedByte(long value) {
        return Long.compareUnsigned(value, 255L) <= 0;
    }

    private static boolean fitsIntoUnsignedShort(int value) {
        return Integer.compareUnsigned(value, 65535) <= 0;
    }

    private static boolean fitsIntoUnsignedShort(long value) {
        return Long.compareUnsigned(value, 65535L) <= 0;
    }

    private static boolean fitsIntoUnsignedInt(long value) {
        return Long.compareUnsigned(value, 0xFFFFFFFFL) <= 0;
    }

    private void addProfile() {
        this.add2(0);
    }

    @Override
    public void add(int opcode) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcode)) : "opcode does not fit into byte";
        this.add1(opcode);
    }

    public void add(int opcode, int value) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcode)) : "opcode does not fit into byte";
        this.add1(opcode);
        this.add4(value);
    }

    public void add(int opcode, long value) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcode)) : "opcode does not fit into byte";
        this.add1(opcode);
        this.add8(value);
    }

    public void add(int opcode, Vector128 value) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcode)) : "opcode does not fit into byte";
        this.add1(opcode);
        this.add16(value);
    }

    public void add(int opcode, int value1, int value2) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcode)) : "opcode does not fit into byte";
        this.add1(opcode);
        this.add4(value1);
        this.add4(value2);
    }

    public void addSigned(int opcodeI8, int opcodeI32, int value) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcodeI8) && RuntimeBytecodeGen.fitsIntoUnsignedByte(opcodeI32)) : "opcode does not fit into byte";
        if (RuntimeBytecodeGen.fitsIntoSignedByte(value)) {
            this.add1(opcodeI8);
            this.add1(value);
        } else {
            this.add1(opcodeI32);
            this.add4(value);
        }
    }

    public void addSigned(int opcodeI8, int opcodeI64, long value) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcodeI8) && RuntimeBytecodeGen.fitsIntoUnsignedByte(opcodeI64)) : "opcode does not fit into byte";
        if (RuntimeBytecodeGen.fitsIntoSignedByte(value)) {
            this.add1(opcodeI8);
            this.add1(value);
        } else {
            this.add1(opcodeI64);
            this.add8(value);
        }
    }

    public void addUnsigned(int opcodeU8, int opcodeI32, int value) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcodeU8) && RuntimeBytecodeGen.fitsIntoSignedByte(opcodeI32)) : "opcode does not fit into byte";
        if (RuntimeBytecodeGen.fitsIntoUnsignedByte(value)) {
            this.add1(opcodeU8);
            this.add1(value);
        } else {
            this.add1(opcodeI32);
            this.add4(value);
        }
    }

    public void addMemoryInstruction(int opcode, int opcodeU8, int opcodeI32, int memoryIndex, long offset, boolean indexType64) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcode) && RuntimeBytecodeGen.fitsIntoUnsignedByte(opcodeU8) && RuntimeBytecodeGen.fitsIntoUnsignedByte(opcodeI32)) : "opcode does not fit into byte";
        if (!indexType64 && memoryIndex == 0) {
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(offset)) {
                this.add1(opcodeU8);
                this.add1(offset);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedInt(offset)) {
                this.add1(opcodeI32);
                this.add4(offset);
            } else {
                this.add1(opcode);
                this.add1(8);
                this.add8(offset);
            }
        } else {
            this.add1(opcode);
            int location = this.location();
            this.add1(0);
            int flags = indexType64 ? 128 : 0;
            this.add4(memoryIndex);
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(offset)) {
                flags |= 1;
                this.add1(offset);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedInt(offset)) {
                flags |= 4;
                this.add4(offset);
            } else {
                flags |= 8;
                this.add8(offset);
            }
            this.set(location, (byte)flags);
        }
    }

    public void addExtendedMemoryInstruction(int opcode, int memoryIndex, long offset, boolean indexType64) {
        assert (RuntimeBytecodeGen.fitsIntoUnsignedByte(opcode)) : "opcode does not fit into byte";
        if (!indexType64) {
            assert (RuntimeBytecodeGen.fitsIntoUnsignedInt(offset)) : "offset does not fit into int";
            this.add1(opcode);
            this.add1(0);
            this.add4(memoryIndex);
            this.add4(offset);
        } else {
            this.add1(opcode);
            int location = this.location();
            this.add1(0);
            this.add4(memoryIndex);
            this.add8(offset);
            int flags = 128;
            this.set(location, (byte)-128);
        }
    }

    public int addLabel(int resultCount, int stackSize, int commonResultType) {
        int location;
        assert (commonResultType == 0 || commonResultType == 1 || commonResultType == 2 || commonResultType == 3) : "invalid result type";
        if (resultCount == 0 && stackSize <= 63) {
            this.add1(2);
            location = this.location();
            this.add1(5);
            this.add1(stackSize);
        } else if (resultCount == 1 && stackSize <= 63) {
            assert (commonResultType != 3) : "Single result value must either have number or reference type.";
            this.add1(2);
            location = this.location();
            this.add1(5);
            if (commonResultType == 1) {
                this.add1(0x80 | stackSize);
            } else if (commonResultType == 2) {
                this.add1(0xC0 | stackSize);
            }
        } else if (resultCount <= 63 && RuntimeBytecodeGen.fitsIntoUnsignedByte(stackSize)) {
            this.add1(3);
            location = this.location();
            this.add1(6);
            this.add1(commonResultType << 6 | resultCount);
            this.add1(stackSize);
        } else {
            this.add1(10);
            location = this.location();
            this.add1(7);
            this.add1(commonResultType);
            this.add4(resultCount);
            this.add4(stackSize);
        }
        return location;
    }

    public int addLoopLabel(int resultCount, int stackSize, int commonResultType) {
        int loopLabel = this.addLabel(resultCount, stackSize, commonResultType);
        this.add(8);
        return loopLabel;
    }

    public int addIfLocation() {
        this.add1(9);
        int location = this.location();
        this.add4(0);
        this.addProfile();
        return location;
    }

    public void addBranch(int location) {
        assert (location >= 0);
        int relativeOffset = location - (this.location() + 1);
        if (relativeOffset <= 0 && relativeOffset >= -255) {
            this.add1(11);
            this.add1(-relativeOffset);
        } else {
            this.add1(12);
            this.add4(relativeOffset);
        }
    }

    public int addBranchLocation() {
        this.add1(12);
        int location = this.location();
        this.add4(0);
        return location;
    }

    public void addBranchIf(int location) {
        assert (location >= 0);
        int relativeOffset = location - (this.location() + 1);
        if (relativeOffset <= 0 && relativeOffset >= -255) {
            this.add1(13);
            this.add1(-relativeOffset);
            this.addProfile();
        } else {
            this.add1(14);
            this.add4(relativeOffset);
            this.addProfile();
        }
    }

    public int addBranchIfLocation() {
        this.add1(14);
        int location = this.location();
        this.add4(0);
        this.addProfile();
        return location;
    }

    public void addBranchTable(int size) {
        if (RuntimeBytecodeGen.fitsIntoUnsignedByte(size)) {
            this.add1(15);
            this.add1(size);
            this.addProfile();
        } else {
            this.add1(16);
            this.add4(size);
            this.addProfile();
        }
    }

    public int addBranchTableItemLocation() {
        int location = this.location();
        this.add4(0);
        this.addProfile();
        return location;
    }

    public void patchLocation(int jumpOffsetLocation, int targetLocation) {
        int relativeOffset = targetLocation - jumpOffsetLocation;
        this.set(jumpOffsetLocation, (byte)(relativeOffset & 0xFF));
        this.set(jumpOffsetLocation + 1, (byte)(relativeOffset >>> 8 & 0xFF));
        this.set(jumpOffsetLocation + 2, (byte)(relativeOffset >>> 16 & 0xFF));
        this.set(jumpOffsetLocation + 3, (byte)(relativeOffset >>> 24 & 0xFF));
    }

    public void addCall(int nodeIndex, int functionIndex) {
        if (RuntimeBytecodeGen.fitsIntoUnsignedByte(nodeIndex) && RuntimeBytecodeGen.fitsIntoUnsignedByte(functionIndex)) {
            this.add1(17);
            this.add1(nodeIndex);
            this.add1(functionIndex);
        } else {
            this.add1(18);
            this.add4(nodeIndex);
            this.add4(functionIndex);
        }
    }

    public void addIndirectCall(int nodeIndex, int typeIndex, int tableIndex) {
        if (RuntimeBytecodeGen.fitsIntoUnsignedByte(nodeIndex) && RuntimeBytecodeGen.fitsIntoUnsignedByte(typeIndex) && RuntimeBytecodeGen.fitsIntoUnsignedByte(tableIndex)) {
            this.add1(19);
            this.add1(nodeIndex);
            this.add1(typeIndex);
            this.add1(tableIndex);
        } else {
            this.add1(20);
            this.add4(nodeIndex);
            this.add4(typeIndex);
            this.add4(tableIndex);
        }
    }

    public void addSelect(int instruction) {
        this.add1(instruction);
        this.addProfile();
    }

    private void addDataHeader(int mode, int length, byte[] offsetBytecode, long offsetAddress, int memoryIndex) {
        assert (offsetBytecode == null || offsetAddress == -1L) : "data header does not allow offset bytecode and offset address";
        assert (mode == 0 || mode == 1) : "invalid segment mode in data header";
        int firstByteLocation = this.location();
        this.add1(0);
        int firstByteFlags = mode;
        if (RuntimeBytecodeGen.fitsIntoUnsignedByte(length)) {
            firstByteFlags |= 0x40;
            this.add1(length);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(length)) {
            firstByteFlags |= 0x80;
            this.add2(length);
        } else {
            firstByteFlags |= 0xC0;
            this.add4(length);
        }
        if (offsetBytecode != null) {
            firstByteFlags |= 0;
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(offsetBytecode.length)) {
                firstByteFlags |= 2;
                this.add1(offsetBytecode.length);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(offsetBytecode.length)) {
                firstByteFlags |= 4;
                this.add2(offsetBytecode.length);
            } else {
                firstByteFlags |= 6;
                this.add4(offsetBytecode.length);
            }
            this.addBytes(offsetBytecode, 0, offsetBytecode.length);
        }
        if (offsetAddress != -1L) {
            firstByteFlags |= 0x10;
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(offsetAddress)) {
                firstByteFlags |= 2;
                this.add1(offsetAddress);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(offsetAddress)) {
                firstByteFlags |= 4;
                this.add2(offsetAddress);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedInt(offsetAddress)) {
                firstByteFlags |= 6;
                this.add4(offsetAddress);
            } else {
                firstByteFlags |= 8;
                this.add8(offsetAddress);
            }
        }
        if (memoryIndex == 0) {
            firstByteFlags |= 0x20;
        }
        this.set(firstByteLocation, (byte)firstByteFlags);
        if (memoryIndex != -1 && memoryIndex != 0) {
            int secondByteLocation = this.location();
            this.add1(0);
            int secondByteFlags = 0;
            if (RuntimeBytecodeGen.fitsIntoSixBits(memoryIndex)) {
                secondByteFlags |= 0;
                secondByteFlags |= memoryIndex;
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedByte(memoryIndex)) {
                secondByteFlags |= 0x40;
                this.add1(memoryIndex);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(memoryIndex)) {
                secondByteFlags |= 0x80;
                this.add2(memoryIndex);
            } else {
                secondByteFlags |= 0xC0;
                this.add4(memoryIndex);
            }
            this.set(secondByteLocation, (byte)secondByteFlags);
        }
    }

    public void addDataHeader(int length, byte[] offsetBytecode, long offsetAddress, int memoryIndex) {
        this.addDataHeader(0, length, offsetBytecode, offsetAddress, memoryIndex);
    }

    public void addDataHeader(int mode, int length) {
        assert (mode != 0) : "invalid active segment mode in passive data header";
        this.addDataHeader(mode, length, null, -1L, -1);
    }

    public void addDataRuntimeHeader(int length) {
        int location = this.location();
        this.add1(0);
        int flags = 0;
        if (length <= 63) {
            flags = length;
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedByte(length)) {
            flags |= 0x40;
            this.add1(length);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(length)) {
            flags |= 0x80;
            this.add2(length);
        } else {
            flags |= 0xC0;
            this.add4(length);
        }
        this.set(location, (byte)flags);
    }

    public int addElemHeader(int mode, int count, byte elemType, int tableIndex, byte[] offsetBytecode, int offsetAddress) {
        assert (offsetBytecode == null || offsetAddress == -1) : "elem header does not allow offset bytecode and offset address";
        assert (mode == 0 || mode == 1 || mode == 2) : "invalid segment mode in elem header";
        assert (elemType == 112 || elemType == 111) : "invalid elem type in elem header";
        int location = this.location();
        this.add1(0);
        this.add1((switch (elemType) {
            case 112 -> 16;
            case 111 -> 32;
            default -> throw CompilerDirectives.shouldNotReachHere();
        }) | mode);
        int flags = 0;
        if (RuntimeBytecodeGen.fitsIntoUnsignedByte(count)) {
            flags |= 0x40;
            this.add1(count);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(count)) {
            flags |= 0x80;
            this.add2(count);
        } else {
            flags |= 0xC0;
            this.add4(count);
        }
        if (tableIndex != 0) {
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(tableIndex)) {
                flags |= 0x10;
                this.add1(tableIndex);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(tableIndex)) {
                flags |= 0x20;
                this.add2(tableIndex);
            } else {
                flags |= 0x30;
                this.add4(tableIndex);
            }
        }
        if (offsetBytecode != null) {
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(offsetBytecode.length)) {
                flags |= 4;
                this.add1(offsetBytecode.length);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(offsetBytecode.length)) {
                flags |= 8;
                this.add2(offsetBytecode.length);
            } else {
                flags |= 0xC;
                this.add4(offsetBytecode.length);
            }
            this.addBytes(offsetBytecode, 0, offsetBytecode.length);
        }
        if (offsetAddress != -1) {
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(offsetAddress)) {
                flags |= 1;
                this.add1(offsetAddress);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(offsetAddress)) {
                flags |= 2;
                this.add2(offsetAddress);
            } else {
                flags |= 3;
                this.add4(offsetAddress);
            }
        }
        this.set(location, (byte)flags);
        return this.location();
    }

    public void addByte(byte value) {
        this.add1(value);
    }

    public void addElemNull() {
        this.add1(16);
    }

    public void addElemFunctionIndex(int functionIndex) {
        if (functionIndex >= 0 && functionIndex <= 15) {
            this.add1(0 | functionIndex);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedByte(functionIndex)) {
            this.add1(32);
            this.add1(functionIndex);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(functionIndex)) {
            this.add1(64);
            this.add2(functionIndex);
        } else {
            this.add1(96);
            this.add4(functionIndex);
        }
    }

    public void addElemGlobalIndex(int globalIndex) {
        if (globalIndex >= 0 && globalIndex <= 15) {
            this.add1(0x80 | globalIndex);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedByte(globalIndex)) {
            this.add1(160);
            this.add1(globalIndex);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(globalIndex)) {
            this.add1(192);
            this.add2(globalIndex);
        } else {
            this.add1(224);
            this.add4(globalIndex);
        }
    }

    public void addCodeEntry(int functionIndex, int maxStackSize, int length, int localCount, int resultCount) {
        int location = this.location();
        this.add1(0);
        int flags = 0;
        if (functionIndex != 0) {
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(functionIndex)) {
                flags |= 0x40;
                this.add1(functionIndex);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(functionIndex)) {
                flags |= 0x80;
                this.add2(functionIndex);
            } else {
                flags |= 0xC0;
                this.add4(functionIndex);
            }
        }
        if (maxStackSize != 0) {
            if (RuntimeBytecodeGen.fitsIntoUnsignedByte(maxStackSize)) {
                flags |= 0x10;
                this.add1(maxStackSize);
            } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(maxStackSize)) {
                flags |= 0x20;
                this.add2(maxStackSize);
            } else {
                flags |= 0x30;
                this.add4(maxStackSize);
            }
        }
        if (RuntimeBytecodeGen.fitsIntoUnsignedByte(length)) {
            flags |= 4;
            this.add1(length);
        } else if (RuntimeBytecodeGen.fitsIntoUnsignedShort(length)) {
            flags |= 8;
            this.add2(length);
        } else {
            flags |= 0xC;
            this.add4(length);
        }
        if (localCount != 0) {
            flags |= 2;
        }
        if (resultCount != 0) {
            flags |= 1;
        }
        this.set(location, (byte)flags);
    }

    public void addNotify(int lineNumber, int sourceCodeLocation) {
        this.add(254);
        this.add4(lineNumber);
        this.add4(sourceCodeLocation);
    }
}

