/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.nodes.WasmInstrumentableFunctionNode;

@GeneratedBy(value=WasmInstrumentableFunctionNode.class)
final class WasmInstrumentableFunctionNodeWrapper
extends WasmInstrumentableFunctionNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private WasmInstrumentableFunctionNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    WasmInstrumentableFunctionNodeWrapper(WasmInstrumentableFunctionNode node, WasmInstrumentableFunctionNode delegateNode, ProbeNode probeNode) {
        super(node);
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public WasmInstrumentableFunctionNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    @Override
    void execute(VirtualFrame frame, WasmInstance instance) {
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                this.delegateNode.execute(frame, instance);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, null);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) break;
                throw t;
            }
            break;
        }
    }
}

