/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import org.graalvm.wasm.MemoryContext;
import org.graalvm.wasm.WasmMath;
import org.graalvm.wasm.api.Vector128Ops;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.UnsafeUtilities;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import sun.misc.Unsafe;

@ExportLibrary(value=WasmMemoryLibrary.class)
public final class NativeWasmMemory
extends WasmMemory {
    private long startAddress;
    private long size;
    private long bufferSize;
    public static final long MAX_ALLOWED_SIZE = 976562500L;
    private static final Unsafe unsafe;
    private static final VarHandle SIZE_FIELD;
    private final MemoryContext memoryContext;
    private final Deallocator deallocator;

    @CompilerDirectives.TruffleBoundary
    private NativeWasmMemory(long declaredMinSize, long declaredMaxSize, long initialSize, long maxAllowedSize, boolean indexType64, MemoryContext memoryContext) {
        super(declaredMinSize, declaredMaxSize, initialSize, maxAllowedSize, indexType64, false);
        long addr;
        long initialBufferSize;
        this.size = initialSize;
        this.memoryContext = memoryContext;
        this.bufferSize = initialBufferSize = this.byteSize();
        this.startAddress = addr = NativeWasmMemory.allocate(initialBufferSize);
        this.deallocator = NativeWasmMemory.registerDeallocator(this, memoryContext, addr);
    }

    @CompilerDirectives.TruffleBoundary
    NativeWasmMemory(long declaredMinSize, long declaredMaxSize, boolean indexType64, MemoryContext memoryContext) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, WasmMath.minUnsigned(declaredMaxSize, 976562500L), indexType64, memoryContext);
    }

    private static long allocate(long newBufferSize) {
        try {
            long address = unsafe.allocateMemory(newBufferSize);
            unsafe.setMemory(address, newBufferSize, (byte)0);
            return address;
        }
        catch (OutOfMemoryError error) {
            throw WasmException.create(Failure.MEMORY_ALLOCATION_FAILED);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private long reallocate(long newBufferSize) {
        try {
            long address = unsafe.reallocateMemory(this.startAddress, newBufferSize);
            unsafe.setMemory(address + this.bufferSize, newBufferSize - this.bufferSize, (byte)0);
            return address;
        }
        catch (OutOfMemoryError error) {
            throw WasmException.create(Failure.MEMORY_ALLOCATION_FAILED);
        }
    }

    private static Deallocator registerDeallocator(NativeWasmMemory memory, MemoryContext memoryContext, long address) {
        Deallocator deallocator = new Deallocator(address);
        memoryContext.registerCleaner(memory, deallocator);
        return deallocator;
    }

    @ExportMessage
    public long size() {
        return SIZE_FIELD.getVolatile(this);
    }

    @ExportMessage
    public long byteSize() {
        return this.size * 65536L;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public synchronized long grow(long extraPageSize) {
        long previousSize = this.size();
        if (extraPageSize == 0L) {
            this.invokeGrowCallback();
            return previousSize;
        }
        if (Long.compareUnsigned(extraPageSize, this.maxAllowedSize()) <= 0 && Long.compareUnsigned(previousSize + extraPageSize, this.maxAllowedSize()) <= 0) {
            long targetPageSize = Math.addExact(previousSize, extraPageSize);
            long targetByteSize = Math.multiplyExact(targetPageSize, 65536);
            if (Long.compareUnsigned(targetByteSize, this.bufferSize) > 0) {
                try {
                    long newBufferSize = this.newBufferSize(targetByteSize);
                    this.startAddress = this.updateDeallocatorAddress(this.reallocate(newBufferSize));
                    this.bufferSize = newBufferSize;
                }
                catch (WasmException error) {
                    try {
                        long newBufferSize = targetByteSize;
                        this.startAddress = this.updateDeallocatorAddress(this.reallocate(newBufferSize));
                        this.bufferSize = newBufferSize;
                    }
                    catch (WasmException errorAgain) {
                        return -1L;
                    }
                }
            }
            this.currentMinSize = targetPageSize;
            SIZE_FIELD.setVolatile(this, targetPageSize);
            this.invokeGrowCallback();
            return previousSize;
        }
        return -1L;
    }

    private long updateDeallocatorAddress(long newAddress) {
        this.deallocator.setAddress(newAddress);
        return newAddress;
    }

    public long newBufferSize(long targetByteSize) {
        long prefBufferSize = Math.addExact(this.bufferSize, this.bufferSize >> 1);
        long maxAllowedByteSize = Math.multiplyExact(this.maxAllowedSize(), 65536);
        return Math.max(targetByteSize, Math.min(prefBufferSize, maxAllowedByteSize));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public synchronized void reset() {
        this.free();
        this.size = this.declaredMinSize;
        this.bufferSize = this.byteSize();
        this.startAddress = this.updateDeallocatorAddress(NativeWasmMemory.allocate(this.bufferSize));
        this.currentMinSize = this.declaredMinSize;
    }

    private void validateAddress(Node node, long address, long length) {
        assert (this.size == 0L || !this.freed());
        NativeWasmMemory.validateAddress(node, address, length, this.byteSize());
    }

    @ExportMessage
    public int load_i32(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return unsafe.getInt(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64(Node node, long address) {
        this.validateAddress(node, address, 8L);
        return unsafe.getLong(this.startAddress + address);
    }

    @ExportMessage
    public float load_f32(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return unsafe.getFloat(this.startAddress + address);
    }

    @ExportMessage
    public double load_f64(Node node, long address) {
        this.validateAddress(node, address, 8L);
        return unsafe.getDouble(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_8s(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return 0xFF & unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_16s(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public int load_i32_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return 0xFFFF & unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_8s(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        return 0xFFL & (long)unsafe.getByte(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_16s(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        return 0xFFFFL & (long)unsafe.getShort(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_32s(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return unsafe.getInt(this.startAddress + address);
    }

    @ExportMessage
    public long load_i64_32u(Node node, long address) {
        this.validateAddress(node, address, 4L);
        return 0xFFFFFFFFL & (long)unsafe.getInt(this.startAddress + address);
    }

    @ExportMessage
    public Object load_i128(Node node, long address) {
        this.validateAddress(node, address, 16L);
        byte[] bytes = new byte[16];
        unsafe.copyMemory(null, this.startAddress + address, bytes, Unsafe.ARRAY_BYTE_BASE_OFFSET, 16L);
        return Vector128Ops.SINGLETON_IMPLEMENTATION.fromArray(bytes);
    }

    @ExportMessage
    public void store_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        unsafe.putInt(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        unsafe.putLong(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_f32(Node node, long address, float value) {
        this.validateAddress(node, address, 4L);
        unsafe.putFloat(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_f64(Node node, long address, double value) {
        this.validateAddress(node, address, 8L);
        unsafe.putDouble(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i32_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        unsafe.putByte(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i32_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        unsafe.putShort(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        unsafe.putByte(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        unsafe.putShort(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i64_32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        unsafe.putInt(this.startAddress + address, value);
    }

    @ExportMessage
    public void store_i128(Node node, long address, Object value) {
        this.validateAddress(node, address, 16L);
        unsafe.copyMemory(Vector128Ops.SINGLETON_IMPLEMENTATION.toArray(Vector128Ops.cast(value)), Unsafe.ARRAY_BYTE_BASE_OFFSET, null, this.startAddress + address, 16L);
    }

    @ExportMessage
    public int atomic_load_i32(Node node, long address) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getIntVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64(Node node, long address) {
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getLongVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public int atomic_load_i32_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        return 0xFF & unsafe.getByteVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public int atomic_load_i32_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        return 0xFFFF & unsafe.getShortVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64_8u(Node node, long address) {
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        return 0xFFL & (long)unsafe.getByteVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64_16u(Node node, long address) {
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        return 0xFFFFL & (long)unsafe.getShortVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public long atomic_load_i64_32u(Node node, long address) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        return 0xFFFFFFFFL & (long)unsafe.getIntVolatile(null, this.startAddress + address);
    }

    @ExportMessage
    public void atomic_store_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        unsafe.putIntVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        unsafe.putLongVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i32_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        unsafe.putByteVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i32_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        unsafe.putShortVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64_8(Node node, long address, byte value) {
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        unsafe.putByteVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64_16(Node node, long address, short value) {
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        unsafe.putShortVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public void atomic_store_i64_32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        unsafe.putIntVolatile(null, this.startAddress + address, value);
    }

    @ExportMessage
    public int atomic_rmw_add_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v + value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_add_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v + value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_add_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndAddInt(null, this.startAddress + address, value);
    }

    @ExportMessage
    public long atomic_rmw_add_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v + value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_add_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v + value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_add_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndAddInt(null, this.startAddress + address, value);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_add_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndAddLong(null, this.startAddress + address, value);
    }

    @ExportMessage
    public int atomic_rmw_sub_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v - value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_sub_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v - value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_sub_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndAddInt(null, this.startAddress + address, -value);
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v - value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v - value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_sub_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndAddInt(null, this.startAddress + address, -value);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_sub_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndAddLong(null, this.startAddress + address, -value);
    }

    @ExportMessage
    public int atomic_rmw_and_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v & value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_and_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v & value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_and_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v & value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v & value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_and_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v & value) != v) {
        }
        return v;
    }

    @ExportMessage
    public int atomic_rmw_or_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v | value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_or_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v | value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_or_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v | value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v | value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_or_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v | value) != v) {
        }
        return v;
    }

    @ExportMessage
    public int atomic_rmw_xor_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v ^ value)) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xor_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v ^ value)) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xor_i32(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), (byte)(v ^ value)) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), (short)(v ^ value)) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64_32u(Node node, long address, int value) {
        int v;
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        while (UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, v = unsafe.getIntVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xor_i64(Node node, long address, long value) {
        long v;
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        while (UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, v = unsafe.getLongVolatile(null, this.startAddress + address), v ^ value) != v) {
        }
        return v;
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_xchg_i32(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        return unsafe.getAndSetInt(null, this.startAddress + address, value);
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_8u(Node node, long address, byte value) {
        byte v;
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        while (UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, v = unsafe.getByteVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_16u(Node node, long address, short value) {
        short v;
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        while (UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, v = unsafe.getShortVolatile(null, this.startAddress + address), value) != v) {
        }
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64_32u(Node node, long address, int value) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = unsafe.getAndSetInt(null, this.startAddress + address, value);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_xchg_i64(Node node, long address, long value) {
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        return unsafe.getAndSetLong(null, this.startAddress + address, value);
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32_8u(Node node, long address, byte expected, byte replacement) {
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        byte v = UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, expected, replacement);
        return 0xFF & v;
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32_16u(Node node, long address, short expected, short replacement) {
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        short v = UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, expected, replacement);
        return 0xFFFF & v;
    }

    @ExportMessage
    public int atomic_rmw_cmpxchg_i32(Node node, long address, int expected, int replacement) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        return UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, expected, replacement);
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_8u(Node node, long address, byte expected, byte replacement) {
        this.validateAddress(node, address, 1L);
        NativeWasmMemory.validateAtomicAddress(node, address, 1);
        byte v = UnsafeUtilities.compareAndExchangeByte(this.startAddress, address, expected, replacement);
        return 0xFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_16u(Node node, long address, short expected, short replacement) {
        this.validateAddress(node, address, 2L);
        NativeWasmMemory.validateAtomicAddress(node, address, 2);
        short v = UnsafeUtilities.compareAndExchangeShort(this.startAddress, address, expected, replacement);
        return 0xFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64_32u(Node node, long address, int expected, int replacement) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        int v = UnsafeUtilities.compareAndExchangeInt(this.startAddress, address, expected, replacement);
        return 0xFFFFFFFFL & (long)v;
    }

    @ExportMessage
    public long atomic_rmw_cmpxchg_i64(Node node, long address, long expected, long replacement) {
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        return UnsafeUtilities.compareAndExchangeLong(this.startAddress, address, expected, replacement);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_notify(Node node, long address, int count) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            return 0;
        }
        return this.invokeNotifyCallback(node, address, count);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait32(Node node, long address, int expected, long timeout) {
        this.validateAddress(node, address, 4L);
        NativeWasmMemory.validateAtomicAddress(node, address, 4);
        if (!this.isShared()) {
            throw NativeWasmMemory.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, false);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait64(Node node, long address, long expected, long timeout) {
        this.validateAddress(node, address, 8L);
        NativeWasmMemory.validateAtomicAddress(node, address, 8);
        if (!this.isShared()) {
            throw NativeWasmMemory.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, true);
    }

    @ExportMessage
    public WasmMemory duplicate() {
        NativeWasmMemory other = new NativeWasmMemory(this.declaredMinSize, this.declaredMaxSize, this.size, this.maxAllowedSize, this.indexType64, this.memoryContext);
        unsafe.copyMemory(this.startAddress, other.startAddress, this.byteSize());
        return other;
    }

    @ExportMessage
    public void initialize(Node node, byte[] source, int sourceOffset, long destinationOffset, int length) {
        NativeWasmMemory.validateLength(node, length);
        this.validateAddress(node, destinationOffset, length);
        if (sourceOffset < 0 || sourceOffset > source.length - length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw NativeWasmMemory.trapOutOfBoundsBuffer(node, sourceOffset, length, source.length);
        }
        unsafe.copyMemory(source, Unsafe.ARRAY_BYTE_BASE_OFFSET + sourceOffset * Unsafe.ARRAY_BYTE_INDEX_SCALE, null, this.startAddress + destinationOffset, length);
    }

    @ExportMessage
    public void fill(Node node, long offset, long length, byte value) {
        NativeWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        unsafe.setMemory(this.startAddress + offset, length, value);
    }

    @ExportMessage
    public void copyFrom(Node node, WasmMemory source, long sourceOffset, long destinationOffset, long length) {
        assert (source instanceof NativeWasmMemory);
        NativeWasmMemory s = (NativeWasmMemory)source;
        NativeWasmMemory.validateLength(node, length);
        s.validateAddress(node, sourceOffset, length);
        this.validateAddress(node, destinationOffset, length);
        unsafe.copyMemory(s.startAddress + sourceOffset, this.startAddress + destinationOffset, length);
    }

    @ExportMessage
    public boolean freed() {
        return this.startAddress == 0L || this.deallocator.getAddress() == 0L;
    }

    private static void free(long addr) {
        unsafe.freeMemory(addr);
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void free() {
        this.deallocator.run();
        this.bufferSize = 0L;
        this.startAddress = 0L;
        this.size = 0L;
    }

    @ExportMessage
    public void close() {
        if (!this.freed()) {
            this.free();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int copyFromStream(Node node, InputStream stream, int offset, int length) throws IOException {
        NativeWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        int totalBytesRead = 0;
        for (int i = 0; i < length; ++i) {
            int byteRead = stream.read();
            if (byteRead == -1) {
                if (totalBytesRead != 0) break;
                return -1;
            }
            unsafe.putByte(this.startAddress + (long)offset + (long)i, (byte)byteRead);
            ++totalBytesRead;
        }
        return totalBytesRead;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void copyToStream(Node node, OutputStream stream, int offset, int length) throws IOException {
        NativeWasmMemory.validateLength(node, length);
        this.validateAddress(node, offset, length);
        for (int i = 0; i < length; ++i) {
            byte b = unsafe.getByte(this.startAddress + (long)offset + (long)i);
            stream.write(b & 0xFF);
        }
    }

    @ExportMessage
    public void copyToBuffer(Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
        NativeWasmMemory.validateLength(node, length);
        this.validateAddress(node, srcOffset, length);
        if (dstOffset < 0 || dstOffset > dst.length - length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw NativeWasmMemory.trapOutOfBoundsBuffer(node, dstOffset, length, dst.length);
        }
        unsafe.copyMemory(null, this.startAddress + srcOffset, dst, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)dstOffset * (long)Unsafe.ARRAY_BYTE_INDEX_SCALE, length);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            SIZE_FIELD = lookup.findVarHandle(NativeWasmMemory.class, "size", Long.TYPE);
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static final class Deallocator
    implements Runnable {
        private volatile long address;
        private static final VarHandle ADDRESS;

        Deallocator(long address) {
            this.address = address;
        }

        @Override
        public void run() {
            long addr = ADDRESS.getAndSet(this, 0);
            if (addr != 0L) {
                NativeWasmMemory.free(addr);
            }
        }

        void setAddress(long address) {
            this.address = address;
        }

        long getAddress() {
            return this.address;
        }

        static {
            try {
                ADDRESS = MethodHandles.lookup().findVarHandle(Deallocator.class, "address", Long.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

